/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.exbin.framework.editor.xbup.viewer.XbupTreeDocument;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.XBTDefaultBlock;

@ParametersAreNonnullByDefault
public class XBDocTreeModel
implements TreeModel {
    private XbupTreeDocument treeDocument = null;
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();

    @Override
    @Nullable
    public Object getRoot() {
        return this.treeDocument == null ? null : this.treeDocument.getRoot();
    }

    @Override
    @Nullable
    public Object getChild(Object parent, int index) {
        return ((XBTBlock)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((XBTBlock)parent).getChildrenCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((XBTBlock)node).getDataMode() == XBBlockDataMode.DATA_BLOCK;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return XBTDefaultBlock.getChildIndexOf((XBTBlock)((XBTBlock)parent), (XBTBlock)((XBTBlock)child));
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.treeModelListeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.treeModelListeners.remove(listener);
    }

    public void setTreeDocument(XbupTreeDocument treeDocument) {
        this.treeDocument = treeDocument;
        this.fireTreeChanged();
    }

    public void fireTreeStructureChanged(XBTBlock oldRoot) {
        int listenersCount = this.treeModelListeners.size();
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < listenersCount; ++i) {
            this.treeModelListeners.get(i).treeStructureChanged(event);
        }
    }

    public void fireTreeChanged() {
        int listenersCount = this.treeModelListeners.size();
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this});
        for (int i = 0; i < listenersCount; ++i) {
            this.treeModelListeners.get(i).treeStructureChanged(event);
        }
    }
}

