/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.popup.DefaultPopupMenu;
import org.exbin.framework.popup.LinkActionsHandler;
import org.exbin.framework.utils.ClipboardUtils;
import org.exbin.framework.utils.DesktopUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.CloseControlPanel;
import org.exbin.framework.xbup.catalog.item.gui.CatalogItemPanel;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFBlockType;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCXIcon;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXIconService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class GeneralBlockPropertiesPanel
extends JPanel {
    private boolean devMode = false;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(GeneralBlockPropertiesPanel.class);
    private XBACatalog catalog;
    private XBTBlock block;
    private XBApplication application;
    private String webCatalogLinkLink;
    private JLabel attributesCountLabel;
    private JTextField attributesCountTextField;
    private JButton catalogButton;
    private JLabel childrenCountLabel;
    private JTextField childrenCountTextField;
    private JMenuItem copyLinkMenuItem;
    private JLabel dataModeLabel;
    private JTextField dataModeTextField;
    private JPanel iconPanel;
    private JLabel itemIconLabel;
    private JLabel itemTitleLabel;
    private JSeparator jSeparator1;
    private JPopupMenu linkPopupMenu;
    private JLabel nodeSizeLabel;
    private JTextField nodeSizeTextField;
    private JLabel terminationModeLabel;
    private JTextField terminationModeTextField;
    private JLabel webCatalogLabel;
    private JLabel webCatalogLinkLabel;
    private JScrollPane webCatalogLinkScrollPane;

    public GeneralBlockPropertiesPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.webCatalogLinkLabel.setComponentPopupMenu(new JPopupMenu(){
            private boolean initialized = false;

            @Override
            public void show(Component invoker, int x, int y) {
                if (!this.initialized) {
                    DefaultPopupMenu.getInstance().appendLinkMenu((JPopupMenu)this, new LinkActionsHandler(){

                        public void performCopyLink() {
                            StringSelection stringSelection = new StringSelection(GeneralBlockPropertiesPanel.this.webCatalogLinkLink);
                            ClipboardUtils.getClipboard().setContents(stringSelection, stringSelection);
                        }

                        public void performOpenLink() {
                            DesktopUtils.openDesktopURL((String)GeneralBlockPropertiesPanel.this.webCatalogLinkLink);
                        }

                        public boolean isLinkSelected() {
                            return true;
                        }
                    });
                    this.initialized = true;
                }
                super.show(invoker, x, y);
            }
        });
    }

    private void initComponents() {
        this.linkPopupMenu = new JPopupMenu();
        this.copyLinkMenuItem = new JMenuItem();
        this.iconPanel = new JPanel();
        this.itemIconLabel = new JLabel();
        this.itemTitleLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.dataModeLabel = new JLabel();
        this.dataModeTextField = new JTextField();
        this.terminationModeLabel = new JLabel();
        this.terminationModeTextField = new JTextField();
        this.nodeSizeLabel = new JLabel();
        this.nodeSizeTextField = new JTextField();
        this.attributesCountLabel = new JLabel();
        this.attributesCountTextField = new JTextField();
        this.childrenCountLabel = new JLabel();
        this.childrenCountTextField = new JTextField();
        this.webCatalogLabel = new JLabel();
        this.webCatalogLinkScrollPane = new JScrollPane();
        this.webCatalogLinkLabel = new JLabel();
        this.webCatalogLinkLabel.setCursor(new Cursor(12));
        this.catalogButton = new JButton();
        this.copyLinkMenuItem.setText(this.resourceBundle.getString("copyLinkMenuItem.text"));
        this.copyLinkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralBlockPropertiesPanel.this.copyLinkMenuItemActionPerformed(evt);
            }
        });
        this.linkPopupMenu.add(this.copyLinkMenuItem);
        this.iconPanel.setBorder(BorderFactory.createEtchedBorder());
        this.iconPanel.setLayout(new BorderLayout());
        this.itemIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/xbup/catalog/item/resources/images/empty.png")));
        this.iconPanel.add((Component)this.itemIconLabel, "Center");
        this.itemTitleLabel.setText("Unknown item");
        this.dataModeLabel.setText(this.resourceBundle.getString("dataModeLabel.text"));
        this.dataModeTextField.setEditable(false);
        this.terminationModeLabel.setText(this.resourceBundle.getString("terminationModeLabel.text"));
        this.terminationModeTextField.setEditable(false);
        this.nodeSizeLabel.setText(this.resourceBundle.getString("nodeSizeLabel.text"));
        this.nodeSizeTextField.setEditable(false);
        this.attributesCountLabel.setText(this.resourceBundle.getString("attributesCountLabel.text"));
        this.attributesCountTextField.setEditable(false);
        this.childrenCountLabel.setText(this.resourceBundle.getString("childrenCountLabel.text"));
        this.childrenCountTextField.setEditable(false);
        this.webCatalogLabel.setText(this.resourceBundle.getString("webCatalogLabell.text"));
        this.webCatalogLinkScrollPane.setHorizontalScrollBarPolicy(31);
        this.webCatalogLinkScrollPane.setVerticalScrollBarPolicy(21);
        this.webCatalogLinkLabel.setText(this.resourceBundle.getString("webCatalogLabel.text"));
        this.webCatalogLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GeneralBlockPropertiesPanel.this.webCatalogLinkLabelMouseClicked(evt);
            }
        });
        this.webCatalogLinkScrollPane.setViewportView(this.webCatalogLinkLabel);
        this.catalogButton.setText("Catalog...");
        this.catalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralBlockPropertiesPanel.this.catalogButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.terminationModeLabel).addComponent(this.nodeSizeLabel).addComponent(this.attributesCountLabel).addComponent(this.childrenCountLabel).addComponent(this.webCatalogLabel).addComponent(this.dataModeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataModeTextField).addComponent(this.childrenCountTextField).addComponent(this.attributesCountTextField).addComponent(this.nodeSizeTextField).addComponent(this.terminationModeTextField).addGroup(layout.createSequentialGroup().addComponent(this.webCatalogLinkScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogButton)))).addGroup(layout.createSequentialGroup().addComponent(this.iconPanel, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.itemTitleLabel, -1, -1, Short.MAX_VALUE)).addComponent(this.jSeparator1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.itemTitleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.iconPanel, -2, 37, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 7, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataModeLabel).addComponent(this.dataModeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.terminationModeLabel).addComponent(this.terminationModeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeSizeLabel).addComponent(this.nodeSizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributesCountLabel).addComponent(this.attributesCountTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.childrenCountLabel).addComponent(this.childrenCountTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.webCatalogLabel).addComponent(this.webCatalogLinkScrollPane, -2, -1, -2).addComponent(this.catalogButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public void setBlock(XBTBlock block) {
        XBBlockDecl decl;
        this.block = block;
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCXIconService iconService = (XBCXIconService)this.catalog.getCatalogService(XBCXIconService.class);
        this.itemTitleLabel.setText(this.getCaption(block));
        this.dataModeTextField.setText(block.getDataMode() == XBBlockDataMode.DATA_BLOCK ? "DATA_BLOCK" : "NODE_BLOCK");
        this.terminationModeTextField.setText(block.getTerminationMode() == XBBlockTerminationMode.TERMINATED_BY_ZERO ? "TERMINATED_BY_ZERO" : "SIZE_SPECIFIED");
        this.nodeSizeTextField.setText(block instanceof XBTTreeNode ? Integer.toString(((XBTTreeNode)block).getSizeUB()) : "Unknown");
        this.attributesCountTextField.setText(String.valueOf(block.getAttributesCount()));
        this.childrenCountTextField.setText(String.valueOf(block.getChildrenCount()));
        this.webCatalogLinkLink = this.devMode ? "https://catalog-dev.exbin.org/" : "https://catalog.exbin.org/";
        XBBlockDecl xBBlockDecl = decl = block instanceof XBTTreeNode ? ((XBTTreeNode)block).getBlockDecl() : null;
        if (decl instanceof XBCBlockDecl) {
            XBCBlockSpec spec = ((XBCBlockDecl)decl).getBlockSpecRev().getParent();
            XBCXIcon itemIcon = iconService.getDefaultIcon((XBCItem)spec);
            if (itemIcon != null) {
                ImageIcon icon = iconService.getDefaultImageIcon((XBCItem)spec);
                this.itemIconLabel.setIcon(icon);
            } else {
                this.itemIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/xbup/catalog/item/resources/images/empty.png")));
            }
            Long[] path = specService.getSpecXBPath((XBCSpec)spec);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < path.length; ++i) {
                if (i > 0) {
                    builder.append("/");
                }
                builder.append(path[i]);
            }
            this.webCatalogLinkLink = this.webCatalogLinkLink + "?block=" + builder.toString();
        } else if (block.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
            this.itemIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/editor/xbup/resources/icons/data-block.png")));
        } else {
            this.itemIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/exbin/framework/xbup/catalog/item/resources/images/empty.png")));
        }
        this.webCatalogLinkLabel.setText("<html><a href=\"\">" + this.webCatalogLinkLink + "</a></html>");
        this.webCatalogLinkLabel.setToolTipText("Link to: " + this.webCatalogLinkLink);
    }

    private void webCatalogLinkLabelMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && !evt.isPopupTrigger()) {
            DesktopUtils.openDesktopURL((String)this.webCatalogLinkLink);
        }
    }

    private void copyLinkMenuItemActionPerformed(ActionEvent evt) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.webCatalogLinkLink), null);
    }

    private void catalogButtonActionPerformed(ActionEvent evt) {
        XBBlockDecl decl;
        CatalogItemPanel itemPanel = new CatalogItemPanel();
        itemPanel.setCatalog(this.catalog);
        XBBlockDecl xBBlockDecl = decl = this.block instanceof XBTTreeNode ? ((XBTTreeNode)this.block).getBlockDecl() : null;
        if (decl instanceof XBCBlockDecl) {
            XBCBlockSpec spec = ((XBCBlockDecl)decl).getBlockSpecRev().getParent();
            itemPanel.setItem((XBCItem)spec);
        }
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        CloseControlPanel controlPanel = new CloseControlPanel();
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)itemPanel, (JPanel)controlPanel);
        controlPanel.setHandler(() -> {
            dialog.close();
            dialog.dispose();
        });
        dialog.showCentered((Component)this);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new GeneralBlockPropertiesPanel());
    }

    @Nonnull
    public String getCaption(XBTBlock node) {
        if (node.getDataMode() == XBBlockDataMode.DATA_BLOCK) {
            return this.resourceBundle.getString("node_caption_data");
        }
        XBBlockType blockType = node.getBlockType();
        if (this.catalog != null) {
            XBCBlockDecl blockDecl;
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            XBCBlockDecl xBCBlockDecl = blockDecl = node instanceof XBTTreeNode ? (XBCBlockDecl)((XBTTreeNode)node).getBlockDecl() : null;
            if (blockDecl == null) {
                return this.resourceBundle.getString("node_caption_undefined");
            }
            XBCBlockSpec blockSpec = blockDecl.getBlockSpecRev().getParent();
            return nameService.getDefaultText((XBCItem)blockSpec);
        }
        return this.resourceBundle.getString("node_caption_unknown") + " (" + Integer.toString(((XBFBlockType)blockType).getGroupID().getInt()) + ", " + Integer.toString(((XBFBlockType)blockType).getBlockID().getInt()) + ")";
    }
}

