/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.xbup.viewer.BlockViewer;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCXPlugUi;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTProvider;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTProviderToPullProvider;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.parser_tree.XBTTreeWriter;
import org.exbin.xbup.plugin.XBCatalogPlugin;
import org.exbin.xbup.plugin.XBComponentViewer;
import org.exbin.xbup.plugin.XBComponentViewerCatalogPlugin;
import org.exbin.xbup.plugin.XBPluginRepository;

@ParametersAreNonnullByDefault
public class BlockComponentViewerPanel
extends JPanel {
    private XBApplication application;
    private XBACatalog catalog;
    private JComponent component = null;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BlockComponentViewerPanel.class);
    private JLabel valueLabel;
    private JPanel valuePanel;

    public BlockComponentViewerPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    private void initComponents() {
        this.valueLabel = new JLabel();
        this.valuePanel = new JPanel();
        this.setName("Form");
        this.valueLabel.setText(this.resourceBundle.getString("valueLabel.text"));
        this.valueLabel.setName("valueLabel");
        this.valuePanel.setBackground(UIManager.getDefaults().getColor("TextField.background"));
        this.valuePanel.setName("valuePanel");
        this.valuePanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.valuePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.valueLabel).addGap(0, 698, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.valueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valuePanel, -2, 36, -2).addContainerGap(305, Short.MAX_VALUE)));
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public void setPluginRepository(XBPluginRepository pluginRepository) {
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BlockComponentViewerPanel());
    }

    public void setBlock(XBTBlock block, XBCXPlugUi plugUi, XBCatalogPlugin pluginHandler) {
        long methodIndex = plugUi.getMethodIndex();
        XBComponentViewer componentViewer = ((XBComponentViewerCatalogPlugin)pluginHandler).getComponentViewer(methodIndex);
        if (this.component != null) {
            this.valuePanel.remove(this.component);
        }
        XBPSerialReader serialReader = new XBPSerialReader((XBTPullProvider)new XBTProviderToPullProvider((XBTProvider)new XBTTreeWriter(block)));
        try {
            serialReader.read((XBSerializable)componentViewer);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(BlockComponentViewerPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.component = componentViewer.getViewer();
        this.valuePanel.add((Component)this.component, "Center");
        this.valuePanel.revalidate();
    }

    public void setActiveViewer(BlockViewer viewer) {
    }
}

