/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.def.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.core.parser.token.XBAttribute;

@ParametersAreNonnullByDefault
public class AttributesTableModel
extends AbstractTableModel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AttributesTableModel.class);
    private List<XBAttribute> attributes;
    private ChangeListener changeListener = null;
    private final String[] columnNames;
    private Class[] columnTypes = new Class[]{Integer.class, Integer.class};
    private final boolean[] columnsEditable = new boolean[]{false, true};

    public AttributesTableModel() {
        this.columnNames = new String[]{this.resourceBundle.getString("itemOrder"), this.resourceBundle.getString("itemValue")};
        this.attributes = new ArrayList<XBAttribute>();
    }

    @Override
    public int getRowCount() {
        return this.attributes.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        return this.getTypes()[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnsEditable[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return this.getAttribs().get(rowIndex).convertToNatural().getInt();
        }
        return rowIndex;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount()) {
            if (columnIndex == 1) {
                this.attributes.get(rowIndex).convertToNatural().setValue(((Integer)aValue).intValue());
                this.fireDataChanged();
            } else {
                throw new IllegalStateException();
            }
        }
    }

    @Nonnull
    public List<XBAttribute> getAttribs() {
        return this.attributes;
    }

    public void setAttribs(List<XBAttribute> attributes) {
        this.attributes = attributes;
        this.fireTableDataChanged();
    }

    @Nonnull
    public Class[] getTypes() {
        return this.columnTypes;
    }

    public void setTypes(Class[] types) {
        this.columnTypes = types;
    }

    public int getAttribute(int index) {
        if (index >= this.attributes.size()) {
            return 0;
        }
        XBAttribute attribute = this.attributes.get(index);
        return attribute != null ? attribute.getNaturalInt() : 0;
    }

    public void fireDataChanged() {
        if (this.changeListener != null) {
            this.changeListener.valueChanged();
        }
    }

    public void attachChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    public static interface ChangeListener {
        public void valueChanged();
    }
}

