/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup.action;

import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import org.exbin.framework.editor.xbup.gui.XBDocTreeTransferHandler;
import org.exbin.framework.editor.xbup.viewer.XbupEditorProvider;
import org.exbin.framework.editor.xbup.viewer.XbupFileHandler;
import org.exbin.framework.utils.ClipboardUtils;
import org.exbin.xbup.core.block.XBTBlock;
import org.exbin.xbup.parser_tree.XBTTreeNode;

@ParametersAreNonnullByDefault
public class CopyItemAction
extends AbstractAction {
    public static final String ACTION_ID = "copyItemAction";
    private XbupEditorProvider editorProvider;

    public void setup(XbupEditorProvider editorProvider) {
        this.editorProvider = editorProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CopyItemAction.performCopy(this.editorProvider);
    }

    static void performCopy(XbupEditorProvider viewerProvider) {
        XbupFileHandler xbupFile = (XbupFileHandler)viewerProvider.getActiveFile().get();
        XBTBlock block = xbupFile.getSelectedItem().get();
        if (!(block instanceof XBTTreeNode)) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        XBTTreeNode node = (XBTTreeNode)block;
        Clipboard clipboard = ClipboardUtils.getClipboard();
        XBDocTreeTransferHandler.XBTSelection selection = new XBDocTreeTransferHandler.XBTSelection(node);
        clipboard.setContents(selection, selection);
    }
}

