/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.xbup;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.file.api.FileType;

@ParametersAreNonnullByDefault
public class XBFileFilter
extends FileFilter
implements FileType {
    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = XBFileFilter.getExtension(file);
        if (extension != null && extension.length() >= 2) {
            return extension.substring(0, 2).equals("xb");
        }
        return false;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "All XB Files (*.xb*)";
    }

    @Nonnull
    public String getFileTypeId() {
        return "XBEditor.XBFileType";
    }

    @Nullable
    public static String getExtension(File file) {
        String ext = null;
        String str = file.getName();
        int i = str.lastIndexOf(46);
        if (i > 0 && i < str.length() - 1) {
            ext = str.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

