/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.help.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;

@ParametersAreNonnullByDefault
public class HelpAction
extends AbstractAction {
    public static final String ACTION_ID = "helpAction";
    public static final String HELP_SET_FILE = "help/help.hs";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(HelpAction.class);
    private HelpSet mainHelpSet;
    private HelpBroker mainHelpBroker;
    private ActionListener helpActionLisneter;
    private XBApplication application;

    public void setApplication(XBApplication application) {
        this.application = application;
        ActionUtils.setupAction((Action)this, (ResourceBundle)this.resourceBundle, (String)ACTION_ID);
        this.putValue("dialogMode", true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        try {
            String path = application.getAppDirectory().getCanonicalPath();
            this.mainHelpSet = this.getHelpSet(path + "/" + HELP_SET_FILE);
            if (this.mainHelpSet != null) {
                this.mainHelpBroker = this.mainHelpSet.createHelpBroker();
                this.helpActionLisneter = new CSH.DisplayHelpFromSource(this.mainHelpBroker);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(HelpAction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.helpActionLisneter.actionPerformed(e);
    }

    @Nullable
    private HelpSet getHelpSet(String helpSetFile) {
        HelpSet helpSet = null;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            URL helpSetURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpSetFile);
            File file = new File(this.application.getAppDirectory().getAbsolutePath() + "/" + HELP_SET_FILE);
            if (!file.exists()) {
                file = new File(this.application.getAppDirectory().getAbsolutePath() + "/../" + HELP_SET_FILE);
            }
            if (helpSetURL == null) {
                helpSetURL = file.toURI().toURL();
            }
            helpSet = new HelpSet(null, helpSetURL);
        }
        catch (MalformedURLException | HelpSetException ex) {
            Logger.getLogger(HelpAction.class.getName()).log(Level.INFO, "HelpSet: " + helpSetFile + " not found", ex);
        }
        return helpSet;
    }
}

