/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.catalog.base.XBCXPlugin;
import org.exbin.xbup.core.catalog.base.XBCXStri;
import org.exbin.xbup.core.catalog.base.service.XBCXFileService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import org.exbin.xbup.core.util.StreamUtils;
import org.exbin.xbup.plugin.XBCatalogPlugin;

@ParametersAreNonnullByDefault
public class XBPluginRepository {
    private final Map<Long, XBCatalogPlugin> pluginsCache = new HashMap<Long, XBCatalogPlugin>();
    private XBACatalog catalog;

    public XBACatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
    }

    public XBCatalogPlugin getPluginHandler(XBCXPlugin plugin) {
        XBCXFile plugFile = plugin.getPluginFile();
        if (plugFile == null) {
            return null;
        }
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        if (this.pluginsCache.containsKey(plugFile.getId())) {
            return this.pluginsCache.get(plugFile.getId());
        }
        XBCXFileService fileService = (XBCXFileService)this.catalog.getCatalogService(XBCXFileService.class);
        XBCXStri stri = striService.getItemStringId((XBCItem)plugFile.getNode());
        String filePath = striService.getFullPath(stri);
        filePath = filePath + "/" + plugFile.getFilename();
        InputStream iStream = fileService.getFile(plugFile);
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("jspfplugindownload", ".jar");
            try (FileOutputStream oStream = new FileOutputStream(tmpFile);){
                StreamUtils.copyInputStreamToOutputStream((InputStream)iStream, (OutputStream)oStream);
                iStream.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(XBPluginRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (tmpFile == null) {
            return null;
        }
        return this.loadXBPlugin(tmpFile.getAbsoluteFile().toURI());
    }

    public XBCatalogPlugin loadXBPlugin(URI libraryUri) {
        block8: {
            try {
                URLClassLoader loader = URLClassLoader.newInstance(new URL[]{libraryUri.toURL()}, this.getClass().getClassLoader());
                InputStream pluginRecordStream = null;
                try {
                    URL pluginRecordUrl = new URL("jar:" + libraryUri.toURL().toExternalForm() + "!/META-INF/plugin.txt");
                    pluginRecordStream = pluginRecordUrl.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (pluginRecordStream != null) {
                    try {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        StreamUtils.copyInputStreamToOutputStream(pluginRecordStream, (OutputStream)outputStream);
                        String className = new String(outputStream.toByteArray(), "UTF-8");
                        Class<?> clazz = Class.forName(className, true, loader);
                        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                        return (XBCatalogPlugin)ctor.newInstance(new Object[0]);
                    }
                    catch (IOException outputStream) {
                        break block8;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        Logger.getLogger(XBPluginRepository.class.getName()).log(Level.SEVERE, null, ex);
                        break block8;
                    }
                }
                throw new IllegalStateException("Unable to read plugin.txt");
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(XBPluginRepository.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        throw new IllegalStateException("Unable to load catalog plugin");
    }
}

