/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.plugin.DynamicClassLoader;
import org.exbin.xbup.plugin.LookAndFeelApplier;
import org.exbin.xbup.plugin.XBModule;
import org.exbin.xbup.plugin.XBModuleHandler;
import org.exbin.xbup.plugin.XBModuleInfo;
import org.exbin.xbup.plugin.XBModuleRecord;
import org.exbin.xbup.plugin.XBModuleRepository;

@ParametersAreNonnullByDefault
public class XBDefaultModuleRepository
implements XBModuleRepository {
    private static final String MODULE_FILE = "module.xb";
    private static final String MODULE_ID = "MODULE_ID";
    private final Map<String, XBModuleRecord> modules = new HashMap<String, XBModuleRecord>();
    private final XBModuleHandler moduleHandler;
    private DynamicClassLoader contextClassLoader = new DynamicClassLoader();

    public XBDefaultModuleRepository(XBModuleHandler moduleHandler) {
        this.moduleHandler = moduleHandler;
    }

    @Override
    public void addModulesFrom(URI moduleClassUri) {
        this.addModulePlugin(moduleClassUri, false);
    }

    @Override
    public void addModulesFrom(URL moduleClassUrl) {
        try {
            this.addModulesFrom(moduleClassUrl.toURI());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(XBDefaultModuleRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void loadModulesFromPath(URI pathUri) {
        File directory = new File(pathUri);
        if (directory.exists() && directory.isDirectory()) {
            File[] jarFiles;
            for (File jarFile : jarFiles = directory.listFiles(pathname -> pathname.isFile() && pathname.getName().endsWith(".jar"))) {
                this.addModulePlugin(jarFile.toURI(), true);
            }
        }
    }

    @Override
    public void addModulesFromPath(URL pathUrl) {
        try {
            this.loadModulesFromPath(pathUrl.toURI());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(XBDefaultModuleRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void addClassPathModules() {
        String[] classpathEntries;
        String classpath = System.getProperty("java.class.path");
        for (String classpathEntry : classpathEntries = classpath.split(File.pathSeparator)) {
            this.addModulePlugin(new File(classpathEntry).toURI(), false);
        }
    }

    @Override
    public void addModulesFromManifest(Class manifestClass) {
        try {
            URL moduleClassLocation = manifestClass.getProtectionDomain().getCodeSource().getLocation();
            URL manifestUrl = new URL("jar:" + moduleClassLocation.toExternalForm() + "!/META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestUrl.openStream());
            String classPaths = manifest.getMainAttributes().getValue(new Attributes.Name("Class-Path"));
            String[] paths = classPaths.split(" ");
            String rootDirectory = new File(moduleClassLocation.toURI()).getParentFile().toURI().toString();
            for (String path : paths) {
                try {
                    this.addModulePlugin(new URI(rootDirectory + path), false);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
    }

    @Override
    @Nonnull
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    private void addModulePlugin(URI libraryUri, boolean loadClass) {
        InputStream moduleRecordStream = null;
        try {
            URL moduleRecordUrl = new URL("jar:" + libraryUri.toURL().toExternalForm() + "!/META-INF/" + MODULE_FILE);
            moduleRecordStream = moduleRecordUrl.openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        XBModuleInfo moduleInfo = new XBModuleInfo();
        moduleInfo.setClassLoader(this.contextClassLoader);
        if (moduleRecordStream != null) {
            try {
                XBPullReader pullReader = new XBPullReader(moduleRecordStream);
                XBPProviderSerialHandler serial = new XBPProviderSerialHandler((XBOutput)new XBToXBTPullConvertor((XBPullProvider)pullReader));
                serial.process((XBSerializable)moduleInfo);
            }
            catch (IOException pullReader) {
                // empty catch block
            }
        }
        if (moduleInfo.getModuleId() != null) {
            XBModule module = null;
            try {
                Class<?> clazz;
                if (loadClass) {
                    DynamicClassLoader loader = new DynamicClassLoader(this.contextClassLoader);
                    loader.add(libraryUri.toURL());
                    clazz = Class.forName(moduleInfo.getModuleId(), true, loader);
                    if (LookAndFeelApplier.class.isAssignableFrom(clazz)) {
                        loader = this.contextClassLoader;
                        loader.add(libraryUri.toURL());
                        clazz = Class.forName(moduleInfo.getModuleId(), true, loader);
                    }
                    moduleInfo.setClassLoader(loader);
                } else {
                    clazz = this.contextClassLoader.loadClass(moduleInfo.getModuleId());
                    moduleInfo.setClassLoader(this.contextClassLoader);
                }
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                module = (XBModule)ctor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException exception) {
                // empty catch block
            }
            moduleInfo.setModule(module);
            this.modules.put(moduleInfo.getModuleId(), moduleInfo);
        }
    }

    private void addModule(XBModule module) {
        String canonicalName = module.getClass().getCanonicalName();
        XBModuleInfo moduleInfo = new XBModuleInfo(canonicalName, module, this.contextClassLoader);
        URL moduleClassLocation = moduleInfo.getClass().getProtectionDomain().getCodeSource().getLocation();
        InputStream moduleRecordStream = null;
        try {
            URL moduleRecordUrl = new URL("jar:" + moduleClassLocation.toExternalForm() + "!/META-INF/" + MODULE_FILE);
            moduleRecordStream = moduleRecordUrl.openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (moduleRecordStream != null) {
            try {
                XBPullReader pullReader = new XBPullReader(moduleRecordStream);
                XBPProviderSerialHandler serial = new XBPProviderSerialHandler((XBOutput)new XBToXBTPullConvertor((XBPullProvider)pullReader));
                serial.process((XBSerializable)moduleInfo);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.modules.put(canonicalName, moduleInfo);
    }

    @Override
    public void initModules() {
        int preRoundCount;
        int postRoundCount;
        ArrayList<XBModuleRecord> unprocessedModules = new ArrayList<XBModuleRecord>(this.modules.values());
        int moduleIndex = 0;
        while (moduleIndex < unprocessedModules.size()) {
            XBModuleRecord moduleRecord = (XBModuleRecord)unprocessedModules.get(moduleIndex);
            XBModule module = moduleRecord.getModule();
            if (module instanceof LookAndFeelApplier) {
                module.init(this.moduleHandler);
                unprocessedModules.remove(moduleIndex);
                continue;
            }
            ++moduleIndex;
        }
        do {
            preRoundCount = unprocessedModules.size();
            int moduleIndex2 = 0;
            while (moduleIndex2 < unprocessedModules.size()) {
                XBModuleRecord moduleRecord = (XBModuleRecord)unprocessedModules.get(moduleIndex2);
                List<String> dependencyModuleIds = moduleRecord.getDependencyModuleIds();
                boolean dependecySatisfied = true;
                for (String dependecyModuleId : dependencyModuleIds) {
                    XBModuleRecord dependecyModule = this.getModuleRecordById(dependecyModuleId);
                    if (dependecyModule != null && !this.findModule(unprocessedModules, dependecyModuleId)) continue;
                    dependecySatisfied = false;
                    break;
                }
                if (dependecySatisfied) {
                    XBModule module = moduleRecord.getModule();
                    module.init(this.moduleHandler);
                    unprocessedModules.remove(moduleIndex2);
                    continue;
                }
                ++moduleIndex2;
            }
        } while ((postRoundCount = unprocessedModules.size()) > 0 && postRoundCount < preRoundCount);
        if (postRoundCount > 0) {
            throw new IllegalStateException("Circular dependency detected");
        }
    }

    @Override
    @Nullable
    public XBModuleRecord getModuleRecordById(String moduleId) {
        return this.modules.get(moduleId);
    }

    private boolean findModule(List<XBModuleRecord> modules, String moduleId) {
        return modules.stream().anyMatch(module -> moduleId.equals(module.getModuleId()));
    }

    @Override
    @Nonnull
    public XBModule getModuleById(String moduleId) {
        XBModuleRecord moduleRecord = this.getModuleRecordById(moduleId);
        if (moduleRecord == null) {
            throw new IllegalArgumentException("Module for id " + moduleId + " was not found.");
        }
        return moduleRecord.getModule();
    }

    @Override
    @Nonnull
    public List<XBModuleRecord> getModulesList() {
        return new ArrayList<XBModuleRecord>(this.modules.values());
    }

    @Override
    @Nonnull
    public <T extends XBModule> T getModuleByInterface(Class<T> interfaceClass) {
        try {
            Object moduleId;
            Field declaredField = interfaceClass.getDeclaredField(MODULE_ID);
            if (declaredField != null && (moduleId = declaredField.get(null)) instanceof String) {
                XBModule module = this.getModuleById((String)moduleId);
                return (T)module;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(XBDefaultModuleRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
        throw new IllegalArgumentException("Module for class " + interfaceClass.getCanonicalName() + " was not found.");
    }
}

