/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.operation.BinaryDataCommand;
import org.exbin.bined.operation.BinaryDataCompoundCommand;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.command.CodeAreaCommand;
import org.exbin.bined.operation.swing.command.CodeAreaCommandType;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class BinaryCompoundCommand
extends CodeAreaCommand
implements BinaryDataCompoundCommand {
    private final List<BinaryDataCommand> commands = new ArrayList<BinaryDataCommand>();

    public BinaryCompoundCommand(@Nonnull CodeAreaCore codeArea) {
        super(codeArea);
    }

    @Nullable
    public static CodeAreaCommand buildCompoundCommand(CodeAreaCore codeArea, CodeAreaCommand ... commands) {
        CodeAreaCommand resultCommand = null;
        for (CodeAreaCommand command : commands) {
            if (command == null) continue;
            if (resultCommand == null) {
                resultCommand = command;
                continue;
            }
            if (resultCommand instanceof BinaryCompoundCommand) {
                ((BinaryCompoundCommand)resultCommand).appendCommand((BinaryDataCommand)command);
                continue;
            }
            BinaryCompoundCommand compoundCommand = new BinaryCompoundCommand(codeArea);
            compoundCommand.appendCommand((BinaryDataCommand)resultCommand);
            compoundCommand.appendCommand((BinaryDataCommand)command);
            resultCommand = compoundCommand;
        }
        return resultCommand;
    }

    @Override
    @Nonnull
    public CodeAreaCommandType getType() {
        return CodeAreaCommandType.COMPOUND;
    }

    public void execute() throws BinaryDataOperationException {
        for (BinaryDataCommand command : this.commands) {
            command.execute();
        }
    }

    public void redo() throws BinaryDataOperationException {
        for (BinaryDataCommand command : this.commands) {
            command.redo();
        }
    }

    public void undo() throws BinaryDataOperationException {
        for (int i = this.commands.size() - 1; i >= 0; --i) {
            BinaryDataCommand command = this.commands.get(i);
            command.undo();
        }
    }

    public boolean canUndo() {
        boolean canUndo = true;
        for (BinaryDataCommand command : this.commands) {
            if (command.canUndo()) continue;
            canUndo = false;
            break;
        }
        return canUndo;
    }

    public void appendCommand(BinaryDataCommand command) {
        this.commands.add(command);
    }

    public void appendCommands(Collection<BinaryDataCommand> commands) {
        this.commands.addAll(commands);
    }

    @Nonnull
    public List<BinaryDataCommand> getCommands() {
        return this.commands;
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        for (BinaryDataCommand command : this.commands) {
            command.dispose();
        }
    }
}

