/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.operation.swing.InsertDataOperation;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class RemoveDataOperation
extends CodeAreaOperation {
    private final long position;
    private final int codeOffset;
    private final long length;

    public RemoveDataOperation(CodeAreaCore codeArea, long position, int codeOffset, long length) {
        super(codeArea);
        this.position = position;
        this.codeOffset = codeOffset;
        this.length = length;
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.REMOVE_DATA;
    }

    @Override
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        EditableBinaryData contentData = (EditableBinaryData)CodeAreaUtils.requireNonNull((Object)((EditableBinaryData)this.codeArea.getContentData()));
        InsertDataOperation undoOperation = null;
        if (executionType == CodeAreaOperation.ExecutionType.WITH_UNDO) {
            EditableBinaryData undoData = (EditableBinaryData)contentData.copy(this.position, this.length);
            undoOperation = new InsertDataOperation(this.codeArea, this.position, this.codeOffset, (BinaryData)undoData);
        }
        contentData.remove(this.position, this.length);
        ((CaretCapable)this.codeArea).setCaretPosition(this.position, this.codeOffset);
        return undoOperation;
    }
}

