/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeType;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.operation.swing.CodeEditDataOperation;
import org.exbin.bined.operation.swing.ModifyDataOperation;
import org.exbin.bined.operation.swing.RemoveDataOperation;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class InsertCodeEditDataOperation
extends CodeEditDataOperation {
    private final long startPosition;
    private final int startCodeOffset;
    private boolean trailing = false;
    private EditableBinaryData trailingValue = null;
    private final CodeType codeType;
    private long length;
    private int codeOffset = 0;

    public InsertCodeEditDataOperation(CodeAreaCore codeArea, long startPosition, int startCodeOffset) {
        super(codeArea);
        this.codeType = ((CodeTypeCapable)codeArea).getCodeType();
        this.startPosition = startPosition;
        this.startCodeOffset = startCodeOffset;
        this.codeOffset = startCodeOffset;
        if (this.codeOffset > 0) {
            this.length = 1L;
        }
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.EDIT_DATA;
    }

    @Override
    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Override
    @Nullable
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        throw new IllegalStateException("Cannot be executed");
    }

    @Override
    public void appendEdit(byte value) {
        EditableBinaryData data = (EditableBinaryData)this.codeArea.getContentData();
        long editedDataPosition = this.startPosition + this.length;
        byte byteValue = 0;
        if (this.codeOffset > 0) {
            byteValue = data.getByte(editedDataPosition - 1L);
            byte byteRest = 0;
            switch (this.codeType) {
                case BINARY: {
                    byteRest = (byte)(byteValue & 255 >> this.codeOffset);
                    break;
                }
                case DECIMAL: {
                    byteRest = (byte)(byteValue % (this.codeOffset == 1 ? 100 : 10));
                    break;
                }
                case OCTAL: {
                    byteRest = (byte)(byteValue % (this.codeOffset == 1 ? 64 : 8));
                    break;
                }
                case HEXADECIMAL: {
                    byteRest = (byte)(byteValue & 0xF);
                    break;
                }
                default: {
                    throw CodeAreaUtils.getInvalidTypeException((Enum)this.codeType);
                }
            }
            if (byteRest > 0) {
                if (this.trailing) {
                    throw new IllegalStateException("Unexpected trailing flag");
                }
                this.trailingValue = (EditableBinaryData)data.copy(editedDataPosition - 1L, 1L);
                data.insert(editedDataPosition, 1L);
                data.setByte(editedDataPosition, byteRest);
                byteValue = (byte)(byteValue - byteRest);
                this.trailing = true;
            }
            --editedDataPosition;
        } else {
            data.insert(editedDataPosition, 1L);
            ++this.length;
        }
        switch (this.codeType) {
            case BINARY: {
                int bitMask = 128 >> this.codeOffset;
                byteValue = (byte)(byteValue & 255 - bitMask | value << 7 - this.codeOffset);
                break;
            }
            case DECIMAL: {
                int newValue = byteValue & 0xFF;
                switch (this.codeOffset) {
                    case 0: {
                        newValue = newValue % 100 + value * 100;
                        if (newValue <= 255) break;
                        newValue = 200;
                        break;
                    }
                    case 1: {
                        newValue = newValue / 100 * 100 + value * 10 + newValue % 10;
                        if (newValue <= 255) break;
                        newValue -= 200;
                        break;
                    }
                    case 2: {
                        newValue = newValue / 10 * 10 + value;
                        if (newValue <= 255) break;
                        newValue -= 200;
                    }
                }
                byteValue = (byte)newValue;
                break;
            }
            case OCTAL: {
                int newValue = byteValue & 0xFF;
                switch (this.codeOffset) {
                    case 0: {
                        newValue = newValue % 64 + value * 64;
                        break;
                    }
                    case 1: {
                        newValue = newValue / 64 * 64 + value * 8 + newValue % 8;
                        break;
                    }
                    case 2: {
                        newValue = newValue / 8 * 8 + value;
                    }
                }
                byteValue = (byte)newValue;
                break;
            }
            case HEXADECIMAL: {
                if (this.codeOffset == 1) {
                    byteValue = (byte)(byteValue & 0xF0 | value);
                    break;
                }
                byteValue = (byte)(byteValue & 0xF | value << 4);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this.codeType);
            }
        }
        data.setByte(editedDataPosition, byteValue);
        ++this.codeOffset;
        if (this.codeOffset == this.codeType.getMaxDigitsForByte()) {
            this.codeOffset = 0;
        }
    }

    @Override
    @Nonnull
    public CodeAreaOperation[] generateUndo() {
        if (this.trailing) {
            ModifyDataOperation modifyDataOperation = new ModifyDataOperation(this.codeArea, this.startPosition, this.trailingValue.copy());
            return new CodeAreaOperation[]{modifyDataOperation, new RemoveDataOperation(this.codeArea, this.startPosition, this.startCodeOffset, this.length)};
        }
        return new CodeAreaOperation[]{new RemoveDataOperation(this.codeArea, this.startPosition, this.startCodeOffset, this.length)};
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public int getStartCodeOffset() {
        return this.startCodeOffset;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        if (this.trailingValue != null) {
            this.trailingValue.dispose();
        }
    }
}

