/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeType;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.operation.swing.CodeEditDataOperation;
import org.exbin.bined.operation.swing.InsertDataOperation;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class DeleteCodeEditDataOperation
extends CodeEditDataOperation {
    private static final char BACKSPACE_CHAR = '\b';
    private static final char DELETE_CHAR = '\u007f';
    private final CodeType codeType;
    private long position;
    private EditableBinaryData undoData = null;

    public DeleteCodeEditDataOperation(CodeAreaCore codeArea, long startPosition) {
        super(codeArea);
        this.codeType = ((CodeTypeCapable)codeArea).getCodeType();
        this.position = startPosition;
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.EDIT_DATA;
    }

    @Override
    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Override
    @Nullable
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        throw new IllegalStateException("Cannot be executed");
    }

    @Override
    public void appendEdit(byte value) {
        EditableBinaryData data = (EditableBinaryData)this.codeArea.getContentData();
        switch (value) {
            case 8: {
                if (this.position <= 0L) break;
                --this.position;
                if (this.undoData == null) {
                    this.undoData = (EditableBinaryData)data.copy(this.position, 1L);
                } else {
                    EditableBinaryData dataCopy = (EditableBinaryData)data.copy(this.position, 1L);
                    this.undoData.insert(0L, (BinaryData)dataCopy);
                    dataCopy.dispose();
                }
                data.remove(this.position, 1L);
                break;
            }
            case 127: {
                if (this.position >= data.getDataSize()) break;
                if (this.undoData == null) {
                    this.undoData = (EditableBinaryData)data.copy(this.position, 1L);
                } else {
                    EditableBinaryData dataCopy = (EditableBinaryData)data.copy(this.position, 1L);
                    this.undoData.insert(0L, (BinaryData)dataCopy);
                    dataCopy.dispose();
                }
                data.remove(this.position, 1L);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected character " + value);
            }
        }
        ((CaretCapable)this.codeArea).setCaretPosition(this.position);
        this.codeArea.repaint();
    }

    @Override
    @Nonnull
    public CodeAreaOperation[] generateUndo() {
        InsertDataOperation insertOperation = new InsertDataOperation(this.codeArea, this.position, 0, this.undoData.copy());
        return new CodeAreaOperation[]{insertOperation};
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        if (this.undoData != null) {
            this.undoData.dispose();
        }
    }
}

