/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.paged.PagedData;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.CharsetStreamTranslator;
import org.exbin.bined.ClipboardHandlingMode;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditOperation;
import org.exbin.bined.SelectionRange;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.EnterKeyHandlingMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.basic.TabKeyHandlingMode;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.ClipboardCapable;
import org.exbin.bined.capability.CodeCharactersCaseCapable;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.capability.EditModeCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.capability.ViewModeCapable;
import org.exbin.bined.operation.BinaryDataCommand;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CodeAreaUndoHandler;
import org.exbin.bined.operation.swing.command.BinaryCompoundCommand;
import org.exbin.bined.operation.swing.command.CodeAreaCommand;
import org.exbin.bined.operation.swing.command.CodeAreaCommandType;
import org.exbin.bined.operation.swing.command.EditCharDataCommand;
import org.exbin.bined.operation.swing.command.EditCodeDataCommand;
import org.exbin.bined.operation.swing.command.EditDataCommand;
import org.exbin.bined.operation.swing.command.InsertDataCommand;
import org.exbin.bined.operation.swing.command.ModifyDataCommand;
import org.exbin.bined.operation.swing.command.RemoveDataCommand;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.swing.CodeAreaCommandHandler;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.DefaultCodeAreaCommandHandler;

@ParametersAreNonnullByDefault
public class CodeAreaOperationCommandHandler
implements CodeAreaCommandHandler {
    public static final String MIME_CHARSET = "charset";
    protected static final int CODE_BUFFER_LENGTH = 16;
    protected static final char BACKSPACE_CHAR = '\b';
    protected static final char DELETE_CHAR = '\u007f';
    private final int metaMask = CodeAreaSwingUtils.getMetaMaskDown();
    @Nonnull
    protected final CodeAreaCore codeArea;
    @Nonnull
    private EnterKeyHandlingMode enterKeyHandlingMode = EnterKeyHandlingMode.PLATFORM_SPECIFIC;
    @Nonnull
    private TabKeyHandlingMode tabKeyHandlingMode = TabKeyHandlingMode.PLATFORM_SPECIFIC;
    private final boolean codeTypeSupported;
    private final boolean viewModeSupported;
    protected Clipboard clipboard;
    private boolean canPaste = false;
    private CodeAreaSwingUtils.ClipboardData currentClipboardData = null;
    private DataFlavor binedDataFlavor;
    private DataFlavor binaryDataFlavor;
    protected final BinaryDataUndoHandler undoHandler;
    protected EditDataCommand editCommand = null;

    public CodeAreaOperationCommandHandler(CodeAreaCore codeArea, BinaryDataUndoHandler undoHandler) {
        this.codeArea = codeArea;
        this.undoHandler = undoHandler;
        this.codeTypeSupported = codeArea instanceof CodeTypeCapable;
        this.viewModeSupported = codeArea instanceof ViewModeCapable;
        try {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.clipboard.addFlavorListener(e -> this.updateCanPaste());
            this.binedDataFlavor = new DataFlavor(BinaryData.class, DefaultCodeAreaCommandHandler.BINED_CLIPBOARD_MIME_FULL);
            try {
                this.binaryDataFlavor = new DataFlavor("application/octet-stream");
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.updateCanPaste();
        }
        catch (IllegalStateException ex) {
            this.canPaste = false;
        }
        catch (HeadlessException ex) {
            Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Nonnull
    public static CodeAreaCommandHandler.CodeAreaCommandHandlerFactory createDefaultCodeAreaCommandHandlerFactory() {
        return codeAreaCore -> new CodeAreaOperationCommandHandler(codeAreaCore, new CodeAreaUndoHandler(codeAreaCore));
    }

    @Nonnull
    public BinaryDataUndoHandler getUndoHandler() {
        return this.undoHandler;
    }

    private void updateCanPaste() {
        this.canPaste = CodeAreaSwingUtils.canPaste((Clipboard)this.clipboard, (DataFlavor)this.binedDataFlavor) || CodeAreaSwingUtils.canPaste((Clipboard)this.clipboard, (DataFlavor)DataFlavor.stringFlavor);
    }

    public void undoSequenceBreak() {
        this.editCommand = null;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.codeArea.isEnabled()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 37: {
                this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.LEFT);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 39: {
                this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.RIGHT);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 38: {
                this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.UP);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 40: {
                this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOWN);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 36: {
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0) {
                    this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOC_START);
                } else {
                    this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.ROW_START);
                }
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 35: {
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0) {
                    this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.DOC_END);
                } else {
                    this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.ROW_END);
                }
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 33: {
                this.scroll(ScrollingDirection.PAGE_UP);
                this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.PAGE_UP);
                this.undoSequenceBreak();
                this.revealCursor();
                keyEvent.consume();
                break;
            }
            case 34: {
                this.scroll(ScrollingDirection.PAGE_DOWN);
                this.move(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent), MovementDirection.PAGE_DOWN);
                this.undoSequenceBreak();
                keyEvent.consume();
                break;
            }
            case 155: {
                this.changeEditOperation();
                keyEvent.consume();
                break;
            }
            case 9: {
                this.tabPressed(CodeAreaOperationCommandHandler.isSelectingMode(keyEvent));
                if (this.tabKeyHandlingMode == TabKeyHandlingMode.IGNORE) break;
                keyEvent.consume();
                break;
            }
            case 10: {
                this.enterPressed();
                if (this.enterKeyHandlingMode == EnterKeyHandlingMode.IGNORE) break;
                keyEvent.consume();
                break;
            }
            case 127: {
                this.deletePressed();
                keyEvent.consume();
                break;
            }
            case 8: {
                this.backSpacePressed();
                keyEvent.consume();
                break;
            }
            default: {
                if (((ClipboardCapable)this.codeArea).getClipboardHandlingMode() != ClipboardHandlingMode.PROCESS) break;
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 67) {
                    this.copy();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 88) {
                    this.cut();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) > 0 && keyEvent.getKeyCode() == 86) {
                    this.paste();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiersEx() & this.metaMask) <= 0 || keyEvent.getKeyCode() != 65) break;
                this.codeArea.selectAll();
                keyEvent.consume();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char keyValue = keyEvent.getKeyChar();
        if (keyValue == '\uffff') {
            return;
        }
        if (!this.checkEditAllowed()) {
            return;
        }
        CodeAreaSection section = ((CaretCapable)this.codeArea).getActiveSection();
        if (section != BasicCodeAreaSection.TEXT_PREVIEW) {
            int modifiersEx = keyEvent.getModifiersEx();
            if (modifiersEx == 0 || modifiersEx == 64) {
                this.pressedCharAsCode(keyValue);
            }
        } else if (keyValue > '\u001f' && keyValue != '\u007f') {
            this.pressedCharInPreview(keyValue);
        }
    }

    private void pressedCharAsCode(char keyChar) {
        CodeType codeType;
        CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).getCaretPosition();
        int startCodeOffset = caretPosition.getCodeOffset();
        boolean validKey = CodeAreaUtils.isValidCodeKeyValue((char)keyChar, (int)startCodeOffset, (CodeType)(codeType = this.getCodeType()));
        if (validKey) {
            EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
            EditOperation editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
            DeleteSelectionCommand deleteSelectionCommand = null;
            if (this.codeArea.hasSelection()) {
                long selectionStart = ((SelectionCapable)this.codeArea).getSelection().getFirst();
                deleteSelectionCommand = new DeleteSelectionCommand(this.codeArea);
                ((CaretCapable)this.codeArea).setCaretPosition(selectionStart);
                this.undoSequenceBreak();
            }
            int value = keyChar >= '0' && keyChar <= '9' ? keyChar - 48 : Character.toLowerCase(keyChar) - 97 + 10;
            if (this.editCommand != null && this.editCommand.wasReverted()) {
                this.editCommand = null;
            }
            if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE) {
                if (this.editCommand == null || !(this.editCommand instanceof EditCodeDataCommand) || this.editCommand.getCommandType() != EditDataCommand.EditCommandType.OVERWRITE || !this.isAppendAllowed()) {
                    if (deleteSelectionCommand != null) {
                        BinaryCompoundCommand compoundCommand = new BinaryCompoundCommand(this.codeArea);
                        compoundCommand.appendCommand((BinaryDataCommand)deleteSelectionCommand);
                        try {
                            this.undoHandler.execute((BinaryDataCommand)compoundCommand);
                        }
                        catch (BinaryDataOperationException ex) {
                            Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        int codeOffset = ((CaretCapable)this.codeArea).getCaretPosition().getCodeOffset();
                        this.editCommand = new EditCodeDataCommand(this.codeArea, EditDataCommand.EditCommandType.OVERWRITE, dataPosition, codeOffset);
                        compoundCommand.appendCommand((BinaryDataCommand)this.editCommand);
                    } else {
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        int codeOffset = ((CaretCapable)this.codeArea).getCaretPosition().getCodeOffset();
                        this.editCommand = new EditCodeDataCommand(this.codeArea, EditDataCommand.EditCommandType.OVERWRITE, dataPosition, codeOffset);
                        this.undoHandler.addCommand((BinaryDataCommand)this.editCommand);
                    }
                }
                ((EditCodeDataCommand)this.editCommand).appendEdit((byte)value);
            } else {
                if (this.editCommand == null || !(this.editCommand instanceof EditCodeDataCommand) || this.editCommand.getCommandType() != EditDataCommand.EditCommandType.INSERT || !this.isAppendAllowed()) {
                    if (deleteSelectionCommand != null) {
                        BinaryCompoundCommand compoundCommand = new BinaryCompoundCommand(this.codeArea);
                        compoundCommand.appendCommand((BinaryDataCommand)deleteSelectionCommand);
                        try {
                            this.undoHandler.execute((BinaryDataCommand)compoundCommand);
                        }
                        catch (BinaryDataOperationException ex) {
                            Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        int codeOffset = ((CaretCapable)this.codeArea).getCaretPosition().getCodeOffset();
                        this.editCommand = new EditCodeDataCommand(this.codeArea, EditDataCommand.EditCommandType.INSERT, dataPosition, codeOffset);
                        compoundCommand.appendCommand((BinaryDataCommand)this.editCommand);
                    } else {
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        int codeOffset = ((CaretCapable)this.codeArea).getCaretPosition().getCodeOffset();
                        this.editCommand = new EditCodeDataCommand(this.codeArea, EditDataCommand.EditCommandType.INSERT, dataPosition, codeOffset);
                        this.undoHandler.addCommand((BinaryDataCommand)this.editCommand);
                    }
                }
                ((EditCodeDataCommand)this.editCommand).appendEdit((byte)value);
            }
            this.codeArea.notifyDataChanged();
            this.move(CodeAreaCommandHandler.SelectingMode.NONE, MovementDirection.RIGHT);
            this.revealCursor();
        }
    }

    private void pressedCharInPreview(char keyChar) {
        boolean validKey = this.isValidChar(keyChar);
        if (validKey) {
            EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
            EditOperation editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
            if (this.editCommand != null && this.editCommand.wasReverted()) {
                this.editCommand = null;
            }
            DeleteSelectionCommand deleteCommand = null;
            if (this.codeArea.hasSelection()) {
                this.undoSequenceBreak();
                deleteCommand = new DeleteSelectionCommand(this.codeArea);
            }
            if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE) {
                if (this.editCommand == null || !(this.editCommand instanceof EditCharDataCommand) || this.editCommand.getCommandType() != EditDataCommand.EditCommandType.OVERWRITE || !this.isAppendAllowed()) {
                    if (deleteCommand != null) {
                        BinaryCompoundCommand compoundCommand = new BinaryCompoundCommand(this.codeArea);
                        compoundCommand.appendCommand((BinaryDataCommand)deleteCommand);
                        try {
                            this.undoHandler.execute((BinaryDataCommand)compoundCommand);
                        }
                        catch (BinaryDataOperationException ex) {
                            Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        this.editCommand = new EditCharDataCommand(this.codeArea, EditDataCommand.EditCommandType.OVERWRITE, dataPosition);
                        compoundCommand.appendCommand((BinaryDataCommand)this.editCommand);
                    } else {
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        this.editCommand = new EditCharDataCommand(this.codeArea, EditDataCommand.EditCommandType.OVERWRITE, dataPosition);
                        this.undoHandler.addCommand((BinaryDataCommand)this.editCommand);
                    }
                }
                ((EditCharDataCommand)this.editCommand).appendEdit(keyChar);
            } else {
                if (this.editCommand == null || !(this.editCommand instanceof EditCharDataCommand) || this.editCommand.getCommandType() != EditDataCommand.EditCommandType.INSERT || !this.isAppendAllowed()) {
                    if (deleteCommand != null) {
                        BinaryCompoundCommand compoundCommand = new BinaryCompoundCommand(this.codeArea);
                        compoundCommand.appendCommand((BinaryDataCommand)deleteCommand);
                        try {
                            this.undoHandler.execute((BinaryDataCommand)compoundCommand);
                        }
                        catch (BinaryDataOperationException ex) {
                            Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        this.editCommand = new EditCharDataCommand(this.codeArea, EditDataCommand.EditCommandType.INSERT, dataPosition);
                        compoundCommand.appendCommand((BinaryDataCommand)this.editCommand);
                    } else {
                        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                        this.editCommand = new EditCharDataCommand(this.codeArea, EditDataCommand.EditCommandType.INSERT, dataPosition);
                        this.undoHandler.addCommand((BinaryDataCommand)this.editCommand);
                    }
                }
                ((EditCharDataCommand)this.editCommand).appendEdit(keyChar);
            }
            this.codeArea.notifyDataChanged();
            this.revealCursor();
        }
    }

    public void enterPressed() {
        String sequence;
        if (!this.checkEditAllowed()) {
            return;
        }
        CodeAreaSection section = ((CaretCapable)this.codeArea).getActiveSection();
        if (section == BasicCodeAreaSection.TEXT_PREVIEW && !(sequence = this.enterKeyHandlingMode.getSequence()).isEmpty()) {
            this.pressedCharInPreview(sequence.charAt(0));
            if (sequence.length() == 2) {
                this.pressedCharInPreview(sequence.charAt(1));
            }
        }
    }

    public void tabPressed() {
        this.tabPressed(CodeAreaCommandHandler.SelectingMode.NONE);
    }

    public void tabPressed(CodeAreaCommandHandler.SelectingMode selectingMode) {
        if (!this.checkEditAllowed()) {
            return;
        }
        if (this.tabKeyHandlingMode == TabKeyHandlingMode.PLATFORM_SPECIFIC || this.tabKeyHandlingMode == TabKeyHandlingMode.CYCLE_TO_NEXT_SECTION || this.tabKeyHandlingMode == TabKeyHandlingMode.CYCLE_TO_PREVIOUS_SECTION) {
            if (this.viewModeSupported && ((ViewModeCapable)this.codeArea).getViewMode() == CodeAreaViewMode.DUAL) {
                this.move(selectingMode, MovementDirection.SWITCH_SECTION);
                this.undoSequenceBreak();
                this.revealCursor();
            }
        } else if (((CaretCapable)this.codeArea).getActiveSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
            String sequence = this.tabKeyHandlingMode == TabKeyHandlingMode.INSERT_TAB ? "\t" : "  ";
            this.pressedCharInPreview(sequence.charAt(0));
            if (sequence.length() == 2) {
                this.pressedCharInPreview(sequence.charAt(1));
            }
        }
    }

    public void backSpacePressed() {
        if (!this.checkEditAllowed()) {
            return;
        }
        this.deleteAction('\b');
    }

    public void deletePressed() {
        if (!this.checkEditAllowed()) {
            return;
        }
        this.deleteAction('\u007f');
    }

    private void deleteAction(char keyChar) {
        if (this.codeArea.hasSelection()) {
            DeleteSelectionCommand deleteSelectionCommand = new DeleteSelectionCommand(this.codeArea);
            try {
                this.undoHandler.execute((BinaryDataCommand)deleteSelectionCommand);
                this.undoSequenceBreak();
                this.codeArea.notifyDataChanged();
            }
            catch (BinaryDataOperationException ex) {
                Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            if (this.editCommand != null && this.editCommand.wasReverted()) {
                this.editCommand = null;
            }
            CodeAreaSection section = ((CaretCapable)this.codeArea).getActiveSection();
            long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
            if (section == BasicCodeAreaSection.CODE_MATRIX) {
                if (this.editCommand == null || !(this.editCommand instanceof EditCodeDataCommand) || this.editCommand.getCommandType() != EditDataCommand.EditCommandType.DELETE || !this.isAppendAllowed()) {
                    this.editCommand = new EditCodeDataCommand(this.codeArea, EditDataCommand.EditCommandType.DELETE, dataPosition, 0);
                    this.undoHandler.addCommand((BinaryDataCommand)this.editCommand);
                }
                ((EditCodeDataCommand)this.editCommand).appendEdit((byte)keyChar);
            } else {
                if (this.editCommand == null || !(this.editCommand instanceof EditCharDataCommand) || this.editCommand.getCommandType() != EditDataCommand.EditCommandType.DELETE || !this.isAppendAllowed()) {
                    this.editCommand = new EditCharDataCommand(this.codeArea, EditDataCommand.EditCommandType.DELETE, dataPosition);
                    this.undoHandler.addCommand((BinaryDataCommand)this.editCommand);
                }
                ((EditCharDataCommand)this.editCommand).appendEdit(keyChar);
            }
            this.codeArea.notifyDataChanged();
        }
    }

    public void delete() {
        if (!this.checkEditAllowed()) {
            return;
        }
        try {
            this.undoHandler.execute((BinaryDataCommand)new DeleteSelectionCommand(this.codeArea));
            this.undoSequenceBreak();
            this.codeArea.notifyDataChanged();
        }
        catch (BinaryDataOperationException ex) {
            Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void copy() {
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (!selection.isEmpty()) {
            BinaryData data = this.codeArea.getContentData();
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = data.copy(first, last - first + 1L);
            Charset charset = this.codeArea instanceof CharsetCapable ? ((CharsetCapable)this.codeArea).getCharset() : null;
            CodeAreaSwingUtils.BinaryDataClipboardData binaryData = new CodeAreaSwingUtils.BinaryDataClipboardData(copy, this.binedDataFlavor, this.binaryDataFlavor, charset);
            this.setClipboardContent((CodeAreaSwingUtils.ClipboardData)binaryData);
        }
    }

    public void copyAsCode() {
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (!selection.isEmpty()) {
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = ((BinaryData)CodeAreaUtils.requireNonNull((Object)this.codeArea.getContentData())).copy(first, last - first + 1L);
            CodeType codeType = ((CodeTypeCapable)this.codeArea).getCodeType();
            CodeCharactersCase charactersCase = ((CodeCharactersCaseCapable)this.codeArea).getCodeCharactersCase();
            CodeAreaSwingUtils.CodeDataClipboardData binaryData = new CodeAreaSwingUtils.CodeDataClipboardData(copy, this.binedDataFlavor, codeType, charactersCase);
            this.setClipboardContent((CodeAreaSwingUtils.ClipboardData)binaryData);
        }
    }

    private void setClipboardContent(CodeAreaSwingUtils.ClipboardData content) {
        this.clearClipboardData();
        try {
            this.currentClipboardData = content;
            this.clipboard.setContents((Transferable)content, (ClipboardOwner)content);
        }
        catch (IllegalStateException ex) {
            this.clearClipboardData();
        }
    }

    private void clearClipboardData() {
        if (this.currentClipboardData != null) {
            this.currentClipboardData.dispose();
            this.currentClipboardData = null;
        }
    }

    public void cut() {
        if (!this.checkEditAllowed()) {
            return;
        }
        EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (!selection.isEmpty()) {
            this.copy();
            if (editMode == EditMode.EXPANDING) {
                try {
                    this.undoHandler.execute((BinaryDataCommand)new DeleteSelectionCommand(this.codeArea));
                    this.undoSequenceBreak();
                    this.codeArea.notifyDataChanged();
                }
                catch (BinaryDataOperationException ex) {
                    Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void paste() {
        block16: {
            if (!this.checkEditAllowed()) {
                return;
            }
            try {
                if (!(this.clipboard.isDataFlavorAvailable(this.binedDataFlavor) || this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor) || this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) || this.clipboard.isDataFlavorAvailable(DataFlavor.getTextPlainUnicodeFlavor()))) {
                    return;
                }
            }
            catch (IllegalStateException ex) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binedDataFlavor)) {
                    try {
                        Object clipboardData = this.clipboard.getData(this.binedDataFlavor);
                        if (clipboardData instanceof BinaryData) {
                            this.pasteBinaryData((BinaryData)clipboardData);
                        }
                        break block16;
                    }
                    catch (UnsupportedFlavorException | IOException | IllegalStateException ex) {
                        Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block16;
                }
                try {
                    PagedData pastedData = new PagedData();
                    if (this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor)) {
                        InputStream clipboardData = (InputStream)this.clipboard.getData(this.binaryDataFlavor);
                        pastedData.insert(0L, clipboardData, -1L);
                    } else if (this.clipboard.isDataFlavorAvailable(DataFlavor.getTextPlainUnicodeFlavor())) {
                        InputStream clipboardData = (InputStream)this.clipboard.getData(DataFlavor.getTextPlainUnicodeFlavor());
                        DataFlavor textPlainUnicodeFlavor = DataFlavor.getTextPlainUnicodeFlavor();
                        String charsetName = textPlainUnicodeFlavor.getParameter(MIME_CHARSET);
                        CharsetStreamTranslator translator = new CharsetStreamTranslator(Charset.forName(charsetName), ((CharsetCapable)this.codeArea).getCharset(), clipboardData);
                        pastedData.insert(0L, (InputStream)translator, -1L);
                    } else {
                        String text = (String)this.clipboard.getData(DataFlavor.stringFlavor);
                        pastedData.insert(0L, text.getBytes(((CharsetCapable)this.codeArea).getCharset()));
                    }
                    this.pasteBinaryData((BinaryData)pastedData);
                }
                catch (UnsupportedFlavorException | IOException | IllegalStateException ex) {
                    Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void pasteBinaryData(BinaryData pastedData) {
        CodeAreaCommand pasteCommand;
        DeleteSelectionCommand deleteSelectionCommand = null;
        if (this.codeArea.hasSelection()) {
            try {
                deleteSelectionCommand = new DeleteSelectionCommand(this.codeArea);
                deleteSelectionCommand.execute();
                this.undoSequenceBreak();
            }
            catch (BinaryDataOperationException ex) {
                Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
        EditOperation editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
        long dataSize = this.codeArea.getDataSize();
        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
        ModifyDataCommand modifyCommand = null;
        long clipDataSize = pastedData.getDataSize();
        long insertionPosition = dataPosition;
        if (editMode == EditMode.EXPANDING && editOperation == EditOperation.OVERWRITE || editMode == EditMode.INPLACE) {
            BinaryData modifiedData;
            long replacedPartSize = clipDataSize;
            if (insertionPosition + replacedPartSize > dataSize) {
                replacedPartSize = dataSize - insertionPosition;
                modifiedData = pastedData.copy(0L, replacedPartSize);
            } else {
                modifiedData = pastedData.copy();
            }
            if (replacedPartSize > 0L) {
                modifyCommand = new ModifyDataCommand(this.codeArea, dataPosition, modifiedData);
                if (clipDataSize > replacedPartSize) {
                    pastedData = pastedData.copy(replacedPartSize, clipDataSize - replacedPartSize);
                    insertionPosition += replacedPartSize;
                } else {
                    pastedData = new ByteArrayData();
                }
            }
        }
        InsertDataCommand insertCommand = null;
        if (!pastedData.isEmpty()) {
            insertCommand = new InsertDataCommand(this.codeArea, insertionPosition, pastedData.copy());
        }
        if ((pasteCommand = BinaryCompoundCommand.buildCompoundCommand(this.codeArea, deleteSelectionCommand, modifyCommand, insertCommand)) == null) {
            return;
        }
        try {
            if (modifyCommand != null) {
                modifyCommand.execute();
            }
            if (insertCommand != null) {
                insertCommand.execute();
            }
            this.undoHandler.addCommand((BinaryDataCommand)pasteCommand);
        }
        catch (BinaryDataOperationException ex) {
            Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.undoSequenceBreak();
        this.codeArea.notifyDataChanged();
        this.revealCursor();
        this.clearSelection();
    }

    public void pasteFromCode() {
        block31: {
            if (!this.checkEditAllowed()) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binedDataFlavor)) {
                    this.paste();
                    break block31;
                }
                if (!this.clipboard.isDataFlavorAvailable(DataFlavor.getTextPlainUnicodeFlavor())) break block31;
                DeleteSelectionCommand deleteSelectionCommand = null;
                if (this.codeArea.hasSelection()) {
                    try {
                        deleteSelectionCommand = new DeleteSelectionCommand(this.codeArea);
                        deleteSelectionCommand.execute();
                    }
                    catch (BinaryDataOperationException ex) {
                        Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                long dataSize = this.codeArea.getDataSize();
                try {
                    CodeAreaCommand pasteCommand;
                    byte value;
                    int length;
                    InputStream insertedData = (InputStream)this.clipboard.getData(DataFlavor.getTextPlainUnicodeFlavor());
                    long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
                    ModifyDataCommand modifyCommand = null;
                    CodeType codeType = ((CodeTypeCapable)this.codeArea).getCodeType();
                    int maxDigits = codeType.getMaxDigitsForByte();
                    DataFlavor textPlainUnicodeFlavor = DataFlavor.getTextPlainUnicodeFlavor();
                    String charsetName = textPlainUnicodeFlavor.getParameter(MIME_CHARSET);
                    CharsetStreamTranslator translator = new CharsetStreamTranslator(Charset.forName(charsetName), ((CharsetCapable)this.codeArea).getCharset(), insertedData);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] dataBuffer = new byte[1024];
                    while ((length = translator.read(dataBuffer)) != -1) {
                        outputStream.write(dataBuffer, 0, length);
                    }
                    String insertedString = outputStream.toString(((CharsetCapable)this.codeArea).getCharset().name());
                    ByteArrayEditableData clipData = new ByteArrayEditableData();
                    byte[] buffer = new byte[16];
                    int bufferUsage = 0;
                    int offset = 0;
                    for (int i = 0; i < insertedString.length(); ++i) {
                        char charAt = insertedString.charAt(i);
                        if ((charAt == ' ' || charAt == '\t') && offset == i) {
                            ++offset;
                            continue;
                        }
                        if (charAt == ' ' || charAt == '\t' || charAt == ',' || charAt == ';' || charAt == ':') {
                            value = CodeAreaUtils.stringCodeToByte((String)insertedString.substring(offset, i), (CodeType)codeType);
                            if (bufferUsage < 16) {
                                buffer[bufferUsage] = value;
                                ++bufferUsage;
                            } else {
                                clipData.insert(clipData.getDataSize(), buffer, 0, bufferUsage);
                                bufferUsage = 0;
                            }
                            offset = i + 1;
                            continue;
                        }
                        if (i != offset + maxDigits) continue;
                        value = CodeAreaUtils.stringCodeToByte((String)insertedString.substring(offset, i), (CodeType)codeType);
                        if (bufferUsage < 16) {
                            buffer[bufferUsage] = value;
                            ++bufferUsage;
                        } else {
                            clipData.insert(clipData.getDataSize(), buffer, 0, bufferUsage);
                            bufferUsage = 0;
                        }
                        offset = i;
                    }
                    long clipDataSize = clipData.getDataSize();
                    if (offset < insertedString.length()) {
                        value = CodeAreaUtils.stringCodeToByte((String)insertedString.substring(offset), (CodeType)codeType);
                        if (bufferUsage < 16) {
                            buffer[bufferUsage] = value;
                            ++bufferUsage;
                        } else {
                            clipData.insert(clipDataSize, buffer, 0, bufferUsage);
                            bufferUsage = 0;
                        }
                    }
                    if (bufferUsage > 0) {
                        clipData.insert(clipDataSize, buffer, 0, bufferUsage);
                    }
                    PagedData pastedData = new PagedData();
                    pastedData.insert(0L, (BinaryData)clipData);
                    long pastedDataSize = pastedData.getDataSize();
                    long insertionPosition = dataPosition;
                    PagedData modifiedData = pastedData;
                    long replacedPartSize = clipDataSize;
                    if (insertionPosition + replacedPartSize > dataSize) {
                        replacedPartSize = dataSize - insertionPosition;
                        modifiedData = pastedData.copy(0L, replacedPartSize);
                    }
                    if (replacedPartSize > 0L) {
                        modifyCommand = new ModifyDataCommand(this.codeArea, dataPosition, (BinaryData)modifiedData);
                        if (pastedDataSize > replacedPartSize) {
                            pastedData = pastedData.copy(replacedPartSize, pastedDataSize - replacedPartSize);
                            insertionPosition += replacedPartSize;
                        } else {
                            pastedData.clear();
                        }
                    }
                    InsertDataCommand insertCommand = null;
                    if (pastedData.getDataSize() > 0L) {
                        insertCommand = new InsertDataCommand(this.codeArea, insertionPosition, (BinaryData)pastedData);
                    }
                    if ((pasteCommand = BinaryCompoundCommand.buildCompoundCommand(this.codeArea, deleteSelectionCommand, modifyCommand, insertCommand)) == null) {
                        return;
                    }
                    try {
                        if (modifyCommand != null) {
                            modifyCommand.execute();
                        }
                        if (insertCommand != null) {
                            insertCommand.execute();
                        }
                        this.undoHandler.addCommand((BinaryDataCommand)pasteCommand);
                    }
                    catch (BinaryDataOperationException ex) {
                        Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.undoSequenceBreak();
                    this.codeArea.notifyDataChanged();
                    this.revealCursor();
                    this.clearSelection();
                }
                catch (UnsupportedFlavorException | IOException | IllegalStateException ex) {
                    Logger.getLogger(CodeAreaOperationCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public boolean canPaste() {
        return this.canPaste;
    }

    public void selectAll() {
        long dataSize = this.codeArea.getDataSize();
        if (dataSize > 0L) {
            ((SelectionCapable)this.codeArea).setSelection(0L, dataSize);
        }
    }

    public void clearSelection() {
        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
        ((SelectionCapable)this.codeArea).setSelection(dataPosition, dataPosition);
    }

    public void updateSelection(CodeAreaCommandHandler.SelectingMode selectingMode, CodeAreaCaretPosition caretPosition) {
        long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
        SelectionRange selection = ((SelectionCapable)this.codeArea).getSelection();
        if (selectingMode == CodeAreaCommandHandler.SelectingMode.SELECTING) {
            ((SelectionCapable)this.codeArea).setSelection(selection.getStart(), dataPosition);
        } else {
            ((SelectionCapable)this.codeArea).setSelection(dataPosition, dataPosition);
        }
    }

    public void moveCaret(int positionX, int positionY, CodeAreaCommandHandler.SelectingMode selecting) {
        CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).mousePositionToClosestCaretPosition(positionX, positionY, CaretOverlapMode.PARTIAL_OVERLAP);
        ((CaretCapable)this.codeArea).setCaretPosition(caretPosition);
        this.updateSelection(selecting, caretPosition);
        this.undoSequenceBreak();
        this.codeArea.repaint();
    }

    public void move(CodeAreaCommandHandler.SelectingMode selectingMode, MovementDirection direction) {
        CodeAreaCaretPosition movePosition;
        CodeAreaCaretPosition caretPosition = ((CaretCapable)this.codeArea).getCaretPosition();
        if (!caretPosition.equals(movePosition = ((CaretCapable)this.codeArea).computeMovePosition(caretPosition, direction))) {
            ((CaretCapable)this.codeArea).setCaretPosition(movePosition);
            this.updateSelection(selectingMode, movePosition);
        } else if (selectingMode == CodeAreaCommandHandler.SelectingMode.NONE) {
            this.clearSelection();
        }
    }

    public void scroll(ScrollingDirection direction) {
        CodeAreaScrollPosition scrollPosition;
        CodeAreaScrollPosition sourcePosition = ((ScrollingCapable)this.codeArea).getScrollPosition();
        if (!sourcePosition.equals((Object)(scrollPosition = ((ScrollingCapable)this.codeArea).computeScrolling(sourcePosition, direction)))) {
            ((ScrollingCapable)this.codeArea).setScrollPosition(scrollPosition);
            this.codeArea.resetPainter();
        }
    }

    public void wheelScroll(int scrollSize, CodeAreaCommandHandler.ScrollbarOrientation orientation) {
        block3: {
            block2: {
                if (scrollSize >= 0) break block2;
                for (int i = 0; i < -scrollSize; ++i) {
                    this.scroll(ScrollingDirection.UP);
                }
                break block3;
            }
            if (scrollSize <= 0) break block3;
            for (int i = 0; i < scrollSize; ++i) {
                this.scroll(ScrollingDirection.DOWN);
            }
        }
    }

    private boolean isAppendAllowed() {
        return this.undoHandler.getCommandPosition() != this.undoHandler.getSyncPoint();
    }

    public void changeEditOperation() {
        EditMode editMode = ((EditModeCapable)this.codeArea).getEditMode();
        if (editMode == EditMode.EXPANDING || editMode == EditMode.CAPPED) {
            EditOperation editOperation = ((EditModeCapable)this.codeArea).getEditOperation();
            switch (editOperation) {
                case INSERT: {
                    ((EditModeCapable)this.codeArea).setEditOperation(EditOperation.OVERWRITE);
                    break;
                }
                case OVERWRITE: {
                    ((EditModeCapable)this.codeArea).setEditOperation(EditOperation.INSERT);
                }
            }
        }
    }

    @Nonnull
    public EnterKeyHandlingMode getEnterKeyHandlingMode() {
        return this.enterKeyHandlingMode;
    }

    public void setEnterKeyHandlingMode(EnterKeyHandlingMode enterKeyHandlingMode) {
        this.enterKeyHandlingMode = enterKeyHandlingMode;
    }

    @Nonnull
    public TabKeyHandlingMode getTabKeyHandlingMode() {
        return this.tabKeyHandlingMode;
    }

    public void setTabKeyHandlingMode(TabKeyHandlingMode tabKeyHandlingMode) {
        this.tabKeyHandlingMode = tabKeyHandlingMode;
    }

    public boolean isValidChar(char value) {
        return ((CharsetCapable)this.codeArea).getCharset().canEncode();
    }

    @Nonnull
    private CodeType getCodeType() {
        if (this.codeTypeSupported) {
            return ((CodeTypeCapable)this.codeArea).getCodeType();
        }
        return CodeType.HEXADECIMAL;
    }

    private void revealCursor() {
        ((ScrollingCapable)this.codeArea).revealCursor();
        this.codeArea.repaint();
    }

    public boolean checkEditAllowed() {
        return this.codeArea.isEditable();
    }

    @Nonnull
    private static CodeAreaCommandHandler.SelectingMode isSelectingMode(KeyEvent keyEvent) {
        return (keyEvent.getModifiersEx() & 0x40) > 0 ? CodeAreaCommandHandler.SelectingMode.SELECTING : CodeAreaCommandHandler.SelectingMode.NONE;
    }

    @ParametersAreNonnullByDefault
    private static class DeleteSelectionCommand
    extends CodeAreaCommand {
        private final RemoveDataCommand removeCommand;
        private final long position;
        private final long size;

        public DeleteSelectionCommand(CodeAreaCore coreArea) {
            super(coreArea);
            SelectionRange selection = ((SelectionCapable)coreArea).getSelection();
            this.position = selection.getFirst();
            this.size = selection.getLast() - this.position + 1L;
            this.removeCommand = new RemoveDataCommand(coreArea, this.position, 0, this.size);
        }

        public void execute() throws BinaryDataOperationException {
            super.execute();
        }

        public void redo() throws BinaryDataOperationException {
            this.removeCommand.redo();
            ((CaretCapable)this.codeArea).setCaretPosition(this.position);
            this.clearSelection();
            ((ScrollingCapable)this.codeArea).revealCursor();
            this.codeArea.notifyDataChanged();
        }

        public void undo() throws BinaryDataOperationException {
            this.removeCommand.undo();
            this.clearSelection();
            ((CaretCapable)this.codeArea).setCaretPosition(this.position + this.size);
            ((ScrollingCapable)this.codeArea).revealCursor();
            this.codeArea.notifyDataChanged();
        }

        @Override
        @Nonnull
        public CodeAreaCommandType getType() {
            return CodeAreaCommandType.DATA_REMOVED;
        }

        public boolean canUndo() {
            return true;
        }

        private void clearSelection() {
            long dataPosition = ((CaretCapable)this.codeArea).getDataPosition();
            ((SelectionCapable)this.codeArea).setSelection(dataPosition, dataPosition);
        }
    }
}

