/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.binary_data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.OutOfBoundsException;

@ParametersAreNonnullByDefault
@Immutable
public class EmptyBinaryData
implements BinaryData {
    public static final EmptyBinaryData INSTANCE = new EmptyBinaryData();

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public long getDataSize() {
        return 0L;
    }

    @Override
    public byte getByte(long position) {
        throw new OutOfBoundsException();
    }

    @Override
    @Nonnull
    public BinaryData copy() {
        return this;
    }

    @Override
    @Nonnull
    public BinaryData copy(long startFrom, long length) {
        if (startFrom == 0L && length == 0L) {
            return this;
        }
        throw new OutOfBoundsException();
    }

    @Override
    public void copyToArray(long startFrom, byte[] target, int offset, int length) {
        if (startFrom == 0L && length == 0) {
            return;
        }
        throw new OutOfBoundsException();
    }

    @Override
    public void saveToStream(OutputStream outputStream) throws IOException {
    }

    @Override
    @Nonnull
    public InputStream getDataInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
    }

    @Override
    public void dispose() {
    }
}

