/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.BinaryDataOperationListener;
import org.exbin.bined.operation.swing.CharEditDataOperation;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationEvent;
import org.exbin.bined.operation.swing.CodeAreaOperationListener;
import org.exbin.bined.operation.swing.DeleteCharEditDataOperation;
import org.exbin.bined.operation.swing.InsertCharEditDataOperation;
import org.exbin.bined.operation.swing.OverwriteCharEditDataOperation;
import org.exbin.bined.operation.swing.command.CodeAreaCommandType;
import org.exbin.bined.operation.swing.command.EditDataCommand;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class EditCharDataCommand
extends EditDataCommand {
    @Nonnull
    private final EditDataCommand.EditCommandType commandType;
    protected boolean operationPerformed = false;
    private CodeAreaOperation[] operations = null;

    public EditCharDataCommand(CodeAreaCore codeArea, EditDataCommand.EditCommandType commandType, long position) {
        super(codeArea);
        CharEditDataOperation operation;
        this.commandType = commandType;
        switch (commandType) {
            case INSERT: {
                operation = new InsertCharEditDataOperation(codeArea, position);
                break;
            }
            case OVERWRITE: {
                operation = new OverwriteCharEditDataOperation(codeArea, position);
                break;
            }
            case DELETE: {
                operation = new DeleteCharEditDataOperation(codeArea, position);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)commandType);
            }
        }
        this.operations = new CodeAreaOperation[]{operation};
        this.operationPerformed = true;
    }

    public void undo() throws BinaryDataOperationException {
        if (this.operations.length == 1 && this.operations[0] instanceof CharEditDataOperation) {
            CharEditDataOperation operation = (CharEditDataOperation)this.operations[0];
            this.operations = operation.generateUndo();
            operation.dispose();
        }
        if (this.operationPerformed) {
            for (int i = this.operations.length - 1; i >= 0; --i) {
                CodeAreaOperation operation = this.operations[i];
                CodeAreaOperation redoOperation = operation.executeWithUndo();
                operation.dispose();
                if (this.codeArea instanceof BinaryDataOperationListener) {
                    ((CodeAreaOperationListener)this.codeArea).notifyChange(new CodeAreaOperationEvent(this.operations[i]));
                }
                this.operations[i] = redoOperation;
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.operationPerformed = false;
    }

    public void redo() throws BinaryDataOperationException {
        if (!this.operationPerformed) {
            for (int i = 0; i < this.operations.length; ++i) {
                CodeAreaOperation operation = this.operations[i];
                CodeAreaOperation undoOperation = operation.executeWithUndo();
                operation.dispose();
                if (this.codeArea instanceof BinaryDataOperationListener) {
                    ((CodeAreaOperationListener)this.codeArea).notifyChange(new CodeAreaOperationEvent(operation));
                }
                this.operations[i] = undoOperation;
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.operationPerformed = true;
    }

    @Override
    @Nonnull
    public CodeAreaCommandType getType() {
        return CodeAreaCommandType.DATA_EDITED;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public void appendEdit(char value) {
        if (this.operations.length != 1 || !(this.operations[0] instanceof CharEditDataOperation)) {
            throw new IllegalStateException("Cannot append edit on reverted command");
        }
        ((CharEditDataOperation)this.operations[0]).appendEdit(value);
    }

    @Override
    @Nonnull
    public EditDataCommand.EditCommandType getCommandType() {
        return this.commandType;
    }

    @Override
    public boolean wasReverted() {
        return this.operations.length != 1 || !(this.operations[0] instanceof CharEditDataOperation);
    }

    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        if (this.operations != null) {
            for (CodeAreaOperation operation : this.operations) {
                operation.dispose();
            }
        }
    }
}

