/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeType;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.operation.swing.CodeEditDataOperation;
import org.exbin.bined.operation.swing.ModifyDataOperation;
import org.exbin.bined.operation.swing.RemoveDataOperation;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class OverwriteCodeEditDataOperation
extends CodeEditDataOperation {
    private final long startPosition;
    private final int startCodeOffset;
    private long length = 0L;
    private EditableBinaryData undoData = null;
    private final CodeType codeType;
    private int codeOffset = 0;

    public OverwriteCodeEditDataOperation(CodeAreaCore codeArea, long startPosition, int startCodeOffset) {
        super(codeArea);
        this.startPosition = startPosition;
        this.startCodeOffset = startCodeOffset;
        this.codeOffset = startCodeOffset;
        this.codeType = ((CodeTypeCapable)codeArea).getCodeType();
        if (startCodeOffset > 0 && codeArea.getDataSize() > startPosition) {
            this.undoData = (EditableBinaryData)codeArea.getContentData().copy(startPosition, 1L);
            ++this.length;
        }
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.EDIT_DATA;
    }

    @Override
    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Override
    @Nullable
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        throw new IllegalStateException("Cannot be executed");
    }

    @Override
    public void appendEdit(byte value) {
        EditableBinaryData data = (EditableBinaryData)this.codeArea.getContentData();
        long editedDataPosition = this.startPosition + this.length;
        byte byteValue = 0;
        if (this.codeOffset > 0) {
            if (editedDataPosition <= data.getDataSize()) {
                byteValue = data.getByte(editedDataPosition - 1L);
            }
            --editedDataPosition;
        } else {
            if (editedDataPosition < data.getDataSize()) {
                if (this.undoData == null) {
                    this.undoData = (EditableBinaryData)data.copy(editedDataPosition, 1L);
                    byteValue = this.undoData.getByte(0L);
                } else {
                    this.undoData.insert(this.undoData.getDataSize(), (BinaryData)data, editedDataPosition, 1L);
                }
            } else {
                if (editedDataPosition > data.getDataSize()) {
                    throw new IllegalStateException("Cannot overwrite outside of the document");
                }
                data.insertUninitialized(editedDataPosition, 1L);
            }
            ++this.length;
        }
        byteValue = CodeAreaUtils.setCodeValue((byte)byteValue, (int)value, (int)this.codeOffset, (CodeType)this.codeType);
        data.setByte(editedDataPosition, byteValue);
        ++this.codeOffset;
        if (this.codeOffset == this.codeType.getMaxDigitsForByte()) {
            this.codeOffset = 0;
        }
    }

    @Override
    @Nonnull
    public CodeAreaOperation[] generateUndo() {
        long undoDataSize;
        long removeLength;
        ModifyDataOperation modifyOperation = null;
        if (this.undoData != null && !this.undoData.isEmpty()) {
            modifyOperation = new ModifyDataOperation(this.codeArea, this.startPosition, this.undoData.copy());
        }
        if ((removeLength = this.length - (undoDataSize = this.undoData == null ? 0L : this.undoData.getDataSize())) == 0L) {
            return new CodeAreaOperation[]{modifyOperation};
        }
        RemoveDataOperation removeOperation = new RemoveDataOperation(this.codeArea, this.startPosition + undoDataSize, this.startCodeOffset, removeLength);
        if (modifyOperation != null) {
            return new CodeAreaOperation[]{modifyOperation, removeOperation};
        }
        return new CodeAreaOperation[]{removeOperation};
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public int getStartCodeOffset() {
        return this.startCodeOffset;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        if (this.undoData != null) {
            this.undoData.dispose();
        }
    }
}

