/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CodeAreaOperation;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.operation.swing.RemoveDataOperation;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public class InsertDataOperation
extends CodeAreaOperation {
    private final long position;
    private final int codeOffset;
    private final BinaryData data;

    public InsertDataOperation(CodeAreaCore codeArea, long position, int codeOffset, BinaryData data) {
        super(codeArea);
        this.position = position;
        this.codeOffset = codeOffset;
        this.data = data;
    }

    @Override
    @Nonnull
    public CodeAreaOperationType getType() {
        return CodeAreaOperationType.INSERT_DATA;
    }

    @Override
    @Nullable
    protected CodeAreaOperation execute(CodeAreaOperation.ExecutionType executionType) {
        RemoveDataOperation undoOperation = null;
        ((EditableBinaryData)this.codeArea.getContentData()).insert(this.position, this.data);
        if (executionType == CodeAreaOperation.ExecutionType.WITH_UNDO) {
            undoOperation = new RemoveDataOperation(this.codeArea, this.position, this.codeOffset, this.data.getDataSize());
        }
        ((CaretCapable)this.codeArea).setCaretPosition(this.position + this.data.getDataSize(), this.codeOffset);
        return undoOperation;
    }

    public void appendData(BinaryData appendData) {
        ((EditableBinaryData)this.data).insert(this.data.getDataSize(), appendData);
    }

    @Override
    public void dispose() throws BinaryDataOperationException {
        super.dispose();
        this.data.dispose();
    }
}

