/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.operation.swing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.operation.BinaryDataOperation;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.swing.CodeAreaOperationType;
import org.exbin.bined.swing.CodeAreaCore;

@ParametersAreNonnullByDefault
public abstract class CodeAreaOperation
implements BinaryDataOperation {
    @Nonnull
    protected final CodeAreaCore codeArea;
    @Nonnull
    protected final DefaultCodeAreaCaretPosition backPosition = new DefaultCodeAreaCaretPosition();

    public CodeAreaOperation(CodeAreaCore codeArea) {
        this(codeArea, null);
    }

    public CodeAreaOperation(CodeAreaCore codeArea, @Nullable CodeAreaCaretPosition backPosition) {
        this.codeArea = codeArea;
        if (backPosition != null) {
            this.backPosition.setPosition(backPosition);
        }
    }

    @Nonnull
    public abstract CodeAreaOperationType getType();

    @Nonnull
    public CodeAreaCore getCodeArea() {
        return this.codeArea;
    }

    @Nonnull
    public String getCaption() {
        String caption = this.getType().getCaption();
        return caption == null ? "" : caption;
    }

    @Nonnull
    public CodeAreaCaretPosition getBackPosition() {
        return this.backPosition;
    }

    public void setBackPosition(CodeAreaCaretPosition backPosition) {
        this.backPosition.setPosition(backPosition);
    }

    public void execute() throws BinaryDataOperationException {
        this.execute(ExecutionType.NORMAL);
    }

    @Nullable
    public CodeAreaOperation executeWithUndo() throws BinaryDataOperationException {
        return this.execute(ExecutionType.WITH_UNDO);
    }

    @Nullable
    protected CodeAreaOperation execute(ExecutionType executionType) {
        return null;
    }

    public void dispose() throws BinaryDataOperationException {
    }

    public static enum ExecutionType {
        NORMAL,
        WITH_UNDO;

    }
}

