/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.basic;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaUtils;

@ParametersAreNonnullByDefault
public enum AntialiasingMode {
    OFF,
    AUTO,
    DEFAULT,
    BASIC,
    GASP,
    LCD_HRGB,
    LCD_HBGR,
    LCD_VRGB,
    LCD_VBGR;


    @Nonnull
    public Object getAntialiasingHint(Graphics2D g) {
        Object antialiasingHint;
        switch (this) {
            case AUTO: {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Map map = (Map)tk.getDesktopProperty("awt.font.desktophints");
                if (map != null && (antialiasingHint = map.get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null && antialiasingHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                    return antialiasingHint;
                }
                if (g.getDeviceConfiguration().getDevice().getType() == 0) {
                    antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                    break;
                }
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
                break;
            }
            case BASIC: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case GASP: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
                break;
            }
            case DEFAULT: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
                break;
            }
            case LCD_HRGB: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                break;
            }
            case LCD_HBGR: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
                break;
            }
            case LCD_VRGB: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
                break;
            }
            case LCD_VBGR: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)this);
            }
        }
        return antialiasingHint;
    }
}

