/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.exbin.bined.extended.theme.CodeAreaDecorationType;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.layout.ExtendedCodeAreaDecorations;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.bined.options.gui.PreviewPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ThemeProfilePanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ThemeProfilePanel.class);
    private final PreviewPanel previewPanel = new PreviewPanel();
    private JComboBox<String> backgroundModeComboBox;
    private JLabel backgroundModeLabel;
    private JCheckBox decoratorBoxCheckBox;
    private JCheckBox decoratorHeaderLineCheckBox;
    private JCheckBox decoratorRowPosLineCheckBox;
    private JCheckBox decoratorSplitLineCheckBox;
    private JPanel linesPanel;
    private JCheckBox paintRowPosBackgroundCheckBox;
    private JPanel preferencesPanel;
    private JScrollPane preferencesScrollPane;
    private JLabel verticalLineByteGroupSizeLabel;
    private JSpinner verticalLineByteGroupSizeSpinner;

    public ThemeProfilePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.previewPanel, "Center");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setBackgroundModes(List<String> backgroundModes) {
        for (String backgroundMode : backgroundModes) {
            this.backgroundModeComboBox.addItem(backgroundMode);
        }
    }

    @Nonnull
    public ExtendedCodeAreaThemeProfile getThemeProfile() {
        ExtCodeArea codeArea = this.previewPanel.getCodeArea();
        ExtendedCodeAreaThemeProfile themeProfile = codeArea.getThemeProfile();
        return Objects.requireNonNull(themeProfile).createCopy();
    }

    public void setThemeProfile(ExtendedCodeAreaThemeProfile themeProfile) {
        this.updateThemeProfile(themeProfile);
        this.backgroundModeComboBox.setSelectedIndex(themeProfile.getBackgroundPaintMode().ordinal());
        this.paintRowPosBackgroundCheckBox.setSelected(themeProfile.isPaintRowPosBackground());
        this.decoratorHeaderLineCheckBox.setSelected(themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.HEADER_LINE));
        this.decoratorRowPosLineCheckBox.setSelected(themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.ROW_POSITION_LINE));
        this.decoratorSplitLineCheckBox.setSelected(themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.SPLIT_LINE));
        this.decoratorBoxCheckBox.setSelected(themeProfile.hasDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.BOX_LINES));
        this.verticalLineByteGroupSizeSpinner.setValue(themeProfile.getVerticalLineByteGroupSize());
    }

    private void initComponents() {
        this.preferencesScrollPane = new JScrollPane();
        this.preferencesPanel = new JPanel();
        this.backgroundModeLabel = new JLabel();
        this.backgroundModeComboBox = new JComboBox();
        this.paintRowPosBackgroundCheckBox = new JCheckBox();
        this.linesPanel = new JPanel();
        this.decoratorRowPosLineCheckBox = new JCheckBox();
        this.decoratorSplitLineCheckBox = new JCheckBox();
        this.decoratorBoxCheckBox = new JCheckBox();
        this.decoratorHeaderLineCheckBox = new JCheckBox();
        this.verticalLineByteGroupSizeSpinner = new JSpinner();
        this.verticalLineByteGroupSizeLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.backgroundModeLabel.setText(this.resourceBundle.getString("backgroundModeLabel.text"));
        this.backgroundModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilePanel.this.backgroundModeComboBoxActionPerformed(evt);
            }
        });
        this.paintRowPosBackgroundCheckBox.setText(this.resourceBundle.getString("paintRowPosBackgroundCheckBox.text"));
        this.paintRowPosBackgroundCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeProfilePanel.this.paintRowPosBackgroundCheckBoxItemStateChanged(evt);
            }
        });
        this.linesPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("linesPanel.border.title")));
        this.decoratorRowPosLineCheckBox.setText(this.resourceBundle.getString("decoratorRowPosLineCheckBox.text"));
        this.decoratorRowPosLineCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeProfilePanel.this.decoratorRowPosLineCheckBoxItemStateChanged(evt);
            }
        });
        this.decoratorSplitLineCheckBox.setText(this.resourceBundle.getString("decoratorSplitLineCheckBox.text"));
        this.decoratorSplitLineCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeProfilePanel.this.decoratorSplitLineCheckBoxItemStateChanged(evt);
            }
        });
        this.decoratorBoxCheckBox.setText(this.resourceBundle.getString("decoratorBoxCheckBox.text"));
        this.decoratorBoxCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeProfilePanel.this.decoratorBoxCheckBoxItemStateChanged(evt);
            }
        });
        this.decoratorHeaderLineCheckBox.setText(this.resourceBundle.getString("decoratorHeaderLineCheckBox.text"));
        this.decoratorHeaderLineCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemeProfilePanel.this.decoratorHeaderLineCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout linesPanelLayout = new GroupLayout(this.linesPanel);
        this.linesPanel.setLayout(linesPanelLayout);
        linesPanelLayout.setHorizontalGroup(linesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linesPanelLayout.createSequentialGroup().addContainerGap().addGroup(linesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.decoratorRowPosLineCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.decoratorSplitLineCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.decoratorBoxCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.decoratorHeaderLineCheckBox, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        linesPanelLayout.setVerticalGroup(linesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linesPanelLayout.createSequentialGroup().addComponent(this.decoratorHeaderLineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoratorRowPosLineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoratorSplitLineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoratorBoxCheckBox)));
        this.verticalLineByteGroupSizeSpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.verticalLineByteGroupSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ThemeProfilePanel.this.verticalLineByteGroupSizeSpinnerStateChanged(evt);
            }
        });
        this.verticalLineByteGroupSizeLabel.setText(this.resourceBundle.getString("verticalLineByteGroupSizeLabel.text"));
        GroupLayout preferencesPanelLayout = new GroupLayout(this.preferencesPanel);
        this.preferencesPanel.setLayout(preferencesPanelLayout);
        preferencesPanelLayout.setHorizontalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paintRowPosBackgroundCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.backgroundModeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.linesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.verticalLineByteGroupSizeSpinner, -2, 0, Short.MAX_VALUE).addGroup(preferencesPanelLayout.createSequentialGroup().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundModeLabel).addComponent(this.verticalLineByteGroupSizeLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        preferencesPanelLayout.setVerticalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.backgroundModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backgroundModeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paintRowPosBackgroundCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalLineByteGroupSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verticalLineByteGroupSizeSpinner, -2, -1, -2).addContainerGap(358, Short.MAX_VALUE)));
        this.preferencesScrollPane.setViewportView(this.preferencesPanel);
        this.add((Component)this.preferencesScrollPane, "West");
    }

    private void backgroundModeComboBoxActionPerformed(ActionEvent evt) {
        ExtendedBackgroundPaintMode backgroundPaintMode = ExtendedBackgroundPaintMode.values()[this.backgroundModeComboBox.getSelectedIndex()];
        ExtendedCodeAreaThemeProfile themeProfile = this.getThemeProfile();
        themeProfile.setBackgroundPaintMode(backgroundPaintMode);
        this.updateThemeProfile(themeProfile);
    }

    private void paintRowPosBackgroundCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.paintRowPosBackgroundCheckBox.isSelected();
        ExtendedCodeAreaThemeProfile themeProfile = this.getThemeProfile();
        themeProfile.setPaintRowPosBackground(selected);
        this.updateThemeProfile(themeProfile);
    }

    private void decoratorRowPosLineCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.decoratorRowPosLineCheckBox.isSelected();
        ExtendedCodeAreaThemeProfile themeProfile = this.getThemeProfile();
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.ROW_POSITION_LINE, selected);
        this.updateThemeProfile(themeProfile);
    }

    private void decoratorSplitLineCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.decoratorSplitLineCheckBox.isSelected();
        ExtendedCodeAreaThemeProfile themeProfile = this.getThemeProfile();
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.SPLIT_LINE, selected);
        this.updateThemeProfile(themeProfile);
    }

    private void decoratorBoxCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.decoratorBoxCheckBox.isSelected();
        ExtendedCodeAreaThemeProfile themeProfile = this.getThemeProfile();
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.BOX_LINES, selected);
        this.updateThemeProfile(themeProfile);
    }

    private void decoratorHeaderLineCheckBoxItemStateChanged(ItemEvent evt) {
        boolean selected = this.decoratorHeaderLineCheckBox.isSelected();
        ExtendedCodeAreaThemeProfile themeProfile = this.getThemeProfile();
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.HEADER_LINE, selected);
        this.updateThemeProfile(themeProfile);
    }

    private void verticalLineByteGroupSizeSpinnerStateChanged(ChangeEvent evt) {
        int byteGroupSize = (Integer)this.verticalLineByteGroupSizeSpinner.getValue();
        ExtendedCodeAreaThemeProfile themeProfile = this.getThemeProfile();
        themeProfile.setVerticalLineByteGroupSize(byteGroupSize);
        this.updateThemeProfile(themeProfile);
    }

    private void updateThemeProfile(ExtendedCodeAreaThemeProfile themeProfile) {
        ExtCodeArea codeArea = this.previewPanel.getCodeArea();
        codeArea.setThemeProfile(themeProfile);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ThemeProfilePanel());
    }
}

