/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.exbin.framework.bined.options.gui.ProfileListPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ProfileSelectionPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ProfileSelectionPanel.class);
    private JComboBox<String> defaultProfileComboBox;
    private JLabel defaultProfileLabel;
    private JPanel defaultProfilePanel;

    public ProfileSelectionPanel(JPanel profilePanel) {
        this.initComponents();
        this.addPanel(profilePanel);
        if (profilePanel instanceof ProfileListPanel) {
            final ProfileListPanel listPanel = (ProfileListPanel)((Object)profilePanel);
            listPanel.addProfileListPanelListener(new ListDataListener(){

                @Override
                public void intervalAdded(@Nonnull ListDataEvent event) {
                    List<String> profileNames = listPanel.getProfileNames();
                    int startIndex = event.getIndex0();
                    int endIndex = event.getIndex1();
                    for (int index = startIndex; index <= endIndex; ++index) {
                        DefaultComboBoxModel model = (DefaultComboBoxModel)ProfileSelectionPanel.this.defaultProfileComboBox.getModel();
                        int selectedIndex = ProfileSelectionPanel.this.defaultProfileComboBox.getSelectedIndex();
                        String profileName = profileNames.get(index);
                        model.insertElementAt(profileName, index);
                        if (model.getSize() == 1) {
                            ProfileSelectionPanel.this.defaultProfileComboBox.setSelectedIndex(0);
                            continue;
                        }
                        if (index >= selectedIndex) continue;
                        ProfileSelectionPanel.this.defaultProfileComboBox.setSelectedIndex(selectedIndex + 1);
                    }
                }

                @Override
                public void intervalRemoved(@Nonnull ListDataEvent event) {
                    int endIndex;
                    int startIndex = event.getIndex0();
                    for (int index = endIndex = event.getIndex1(); index >= startIndex; --index) {
                        DefaultComboBoxModel model = (DefaultComboBoxModel)ProfileSelectionPanel.this.defaultProfileComboBox.getModel();
                        int selectedIndex = ProfileSelectionPanel.this.defaultProfileComboBox.getSelectedIndex();
                        model.removeElementAt(index);
                        if (selectedIndex != index || model.getSize() <= 0) continue;
                        ProfileSelectionPanel.this.defaultProfileComboBox.setSelectedIndex(index == 0 ? 0 : index - 1);
                    }
                }

                @Override
                public void contentsChanged(@Nonnull ListDataEvent event) {
                    List<String> profileNames = listPanel.getProfileNames();
                    int startIndex = event.getIndex0();
                    int endIndex = event.getIndex1();
                    for (int index = startIndex; index <= endIndex; ++index) {
                        DefaultComboBoxModel model = (DefaultComboBoxModel)ProfileSelectionPanel.this.defaultProfileComboBox.getModel();
                        boolean selected = ProfileSelectionPanel.this.defaultProfileComboBox.getSelectedIndex() == index;
                        model.removeElementAt(index);
                        model.insertElementAt(profileNames.get(index), index);
                        if (!selected) continue;
                        ProfileSelectionPanel.this.defaultProfileComboBox.setSelectedIndex(index);
                    }
                }
            });
        }
    }

    private void addPanel(JPanel profilePanel) {
        this.add((Component)profilePanel, "Center");
    }

    public void setProfiles(List<String> profiles) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.defaultProfileComboBox.getModel();
        model.removeAllElements();
        profiles.forEach(profile -> model.addElement(profile));
    }

    public void setDefaultProfile(int profileIndex) {
        if (profileIndex >= 0) {
            this.defaultProfileComboBox.setSelectedIndex(profileIndex);
        }
    }

    @Nonnull
    public int getDefaultProfile() {
        return this.defaultProfileComboBox.getSelectedIndex();
    }

    private void initComponents() {
        this.defaultProfilePanel = new JPanel();
        this.defaultProfileLabel = new JLabel();
        this.defaultProfileComboBox = new JComboBox();
        this.setLayout(new BorderLayout());
        this.defaultProfileLabel.setText(this.resourceBundle.getString("defaultProfileLabel.text"));
        GroupLayout defaultProfilePanelLayout = new GroupLayout(this.defaultProfilePanel);
        this.defaultProfilePanel.setLayout(defaultProfilePanelLayout);
        defaultProfilePanelLayout.setHorizontalGroup(defaultProfilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultProfilePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultProfileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultProfileComboBox, 0, 1, Short.MAX_VALUE).addContainerGap()));
        defaultProfilePanelLayout.setVerticalGroup(defaultProfilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultProfilePanelLayout.createSequentialGroup().addContainerGap().addGroup(defaultProfilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultProfileLabel).addComponent(this.defaultProfileComboBox, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.add((Component)this.defaultProfilePanel, "North");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ProfileSelectionPanel(new JPanel()));
    }
}

