/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.bined.options.gui.LayoutProfilesPanel;
import org.exbin.framework.bined.options.gui.ProfileSelectionPanel;
import org.exbin.framework.bined.options.impl.CodeAreaLayoutOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class LayoutProfilesOptionsPanel
extends JPanel
implements OptionsComponent<CodeAreaLayoutOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(LayoutProfilesOptionsPanel.class);
    private final ProfileSelectionPanel selectionPanel;
    private final LayoutProfilesPanel profilesPanel = new LayoutProfilesPanel();

    public LayoutProfilesOptionsPanel() {
        this.selectionPanel = new ProfileSelectionPanel(this.profilesPanel);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.selectionPanel, "North");
        this.add((Component)this.profilesPanel, "Center");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setAddProfileOperation(LayoutProfilesPanel.AddProfileOperation addProfileOperation) {
        this.profilesPanel.setAddProfileOperation(addProfileOperation);
    }

    public void setEditProfileOperation(LayoutProfilesPanel.EditProfileOperation editProfileOperation) {
        this.profilesPanel.setEditProfileOperation(editProfileOperation);
    }

    public void setCopyProfileOperation(LayoutProfilesPanel.CopyProfileOperation copyProfileOperation) {
        this.profilesPanel.setCopyProfileOperation(copyProfileOperation);
    }

    public void setTemplateProfileOperation(LayoutProfilesPanel.TemplateProfileOperation templateProfileOperation) {
        this.profilesPanel.setTemplateProfileOperation(templateProfileOperation);
    }

    public void loadFromOptions(CodeAreaLayoutOptionsImpl options) {
        this.profilesPanel.loadFromOptions(options);
        this.selectionPanel.setDefaultProfile(options.getSelectedProfile());
    }

    public void saveToOptions(CodeAreaLayoutOptionsImpl options) {
        this.profilesPanel.saveToOptions(options);
        options.setSelectedProfile(this.selectionPanel.getDefaultProfile());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new LayoutProfilesOptionsPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

