/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ColorCellPanel
extends JPanel {
    private ColorHandler colorHandler;
    private boolean colorNullable = true;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ColorCellPanel.class);
    private JButton clearButton;
    private JButton colorButton;
    private JLabel colorLabel;

    public ColorCellPanel() {
        this.initComponents();
    }

    public ColorCellPanel(ColorHandler colorHandler) {
        this();
        this.setColorHandler(colorHandler);
    }

    public void setColorHandler(ColorHandler colorHandler) {
        this.colorHandler = colorHandler;
        this.setColor(colorHandler.getColor());
    }

    private void setColor(@Nullable Color color) {
        this.colorLabel.setBorder(color == null ? BorderFactory.createEtchedBorder() : BorderFactory.createBevelBorder(1));
        this.colorLabel.setBackground(color);
    }

    public boolean isColorNullable() {
        return this.colorNullable;
    }

    public void setColorNullable(boolean colorNullable) {
        this.colorNullable = colorNullable;
        this.clearButton.setVisible(colorNullable);
    }

    private void initComponents() {
        this.colorLabel = new JLabel();
        this.colorButton = new JButton();
        this.clearButton = new JButton();
        this.colorLabel.setBorder(BorderFactory.createEtchedBorder());
        this.colorLabel.setOpaque(true);
        this.colorButton.setText(this.resourceBundle.getString("editButton.text"));
        this.colorButton.setAlignmentY(0.0f);
        this.colorButton.setMargin(new Insets(0, 0, 0, 0));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorCellPanel.this.colorButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText(this.resourceBundle.getString("clearButton.text"));
        this.clearButton.setAlignmentY(0.0f);
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorCellPanel.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.colorLabel, -1, 65, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorButton, -2, 72, -2).addGap(0, 0, 0).addComponent(this.clearButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colorButton, -2, 0, Short.MAX_VALUE).addComponent(this.clearButton, -2, 0, Short.MAX_VALUE)));
    }

    private void colorButtonActionPerformed(ActionEvent evt) {
        Color origColor = this.colorHandler.getColor();
        JColorChooser colorChooser = origColor != null ? new JColorChooser(origColor) : new JColorChooser();
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString("selectColor.title"), true, colorChooser, e -> {
            Color color = colorChooser.getColor();
            this.setColor(color);
            this.colorHandler.setColor(color);
        }, null);
        dialog.setVisible(true);
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.setColor(null);
        this.colorHandler.setColor(null);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ColorCellPanel());
    }

    public static interface ColorHandler {
        @Nullable
        public Color getColor();

        public void setColor(@Nullable Color var1);
    }
}

