/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class SelectableColor
extends JPanel {
    private ColorChangedListener colorChangedListener = null;
    private final String label;
    private JLabel colorLabel;
    private JPanel colorPreviewPanel;
    private JButton colorSelectionButton;

    public SelectableColor(String label) {
        this.label = label;
        this.initComponents();
    }

    private void initComponents() {
        this.colorPreviewPanel = new JPanel();
        this.colorSelectionButton = new JButton();
        this.colorLabel = new JLabel();
        this.colorPreviewPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout colorPreviewPanelLayout = new GroupLayout(this.colorPreviewPanel);
        this.colorPreviewPanel.setLayout(colorPreviewPanelLayout);
        colorPreviewPanelLayout.setHorizontalGroup(colorPreviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        colorPreviewPanelLayout.setVerticalGroup(colorPreviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.colorSelectionButton.setText("Select...");
        this.colorSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectableColor.this.colorSelectionButtonActionPerformed(evt);
            }
        });
        this.colorLabel.setLabelFor(this.colorPreviewPanel);
        this.colorLabel.setText(this.label);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.colorLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.colorPreviewPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorSelectionButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.colorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorPreviewPanel, -2, -1, -2).addComponent(this.colorSelectionButton))));
    }

    private void colorSelectionButtonActionPerformed(ActionEvent evt) {
        JColorChooser colorChooser = new JColorChooser();
        JDialog dialog = JColorChooser.createDialog(this, "Select Color", true, colorChooser, e -> {
            Color color = colorChooser.getColor();
            this.colorPreviewPanel.setBackground(color);
            if (this.colorChangedListener != null) {
                this.colorChangedListener.colorChanged(color);
            }
        }, null);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new SelectableColor(""));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.colorPreviewPanel.setEnabled(enabled);
        this.colorLabel.setEnabled(enabled);
        this.colorSelectionButton.setEnabled(enabled);
    }

    @Nonnull
    public Color getColor() {
        return this.colorPreviewPanel.getBackground();
    }

    public void setColor(Color color) {
        this.colorPreviewPanel.setBackground(color);
    }

    @Nullable
    public ColorChangedListener getColorChangedListener() {
        return this.colorChangedListener;
    }

    public void setColorChangedListener(ColorChangedListener colorChangedListener) {
        this.colorChangedListener = colorChangedListener;
    }

    @ParametersAreNonnullByDefault
    public static interface ColorChangedListener {
        public void colorChanged(Color var1);
    }
}

