/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.operation.BinaryDataCommand;
import org.exbin.bined.operation.BinaryDataOperationException;
import org.exbin.bined.operation.undo.BinaryDataUndoHandler;
import org.exbin.bined.operation.undo.BinaryDataUndoUpdateListener;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.undo.XBUndoHandler;
import org.exbin.xbup.operation.undo.XBUndoUpdateListener;

@ParametersAreNonnullByDefault
public class UndoHandlerWrapper
implements XBUndoHandler {
    private BinaryDataUndoHandler handler;
    private final Map<XBUndoUpdateListener, BinaryDataUndoUpdateListener> listenersMap = new HashMap<XBUndoUpdateListener, BinaryDataUndoUpdateListener>();

    public void setHandler(@Nullable BinaryDataUndoHandler newHandler) {
        if (this.handler != null) {
            for (BinaryDataUndoUpdateListener listener : this.listenersMap.values()) {
                this.handler.removeUndoUpdateListener(listener);
            }
        }
        this.handler = newHandler;
        for (BinaryDataUndoUpdateListener listener : this.listenersMap.values()) {
            this.handler.addUndoUpdateListener(listener);
        }
    }

    public boolean canRedo() {
        return this.handler != null ? this.handler.canRedo() : false;
    }

    public boolean canUndo() {
        return this.handler != null ? this.handler.canUndo() : false;
    }

    public void clear() {
        this.handler.clear();
    }

    public void doSync() throws Exception {
        this.handler.doSync();
    }

    public void execute(Command cmnd) throws Exception {
        this.handler.execute((BinaryDataCommand)new BinaryCommandWrapper(cmnd));
    }

    public void addCommand(Command cmnd) {
        this.handler.addCommand((BinaryDataCommand)new BinaryCommandWrapper(cmnd));
    }

    @Nonnull
    public List<Command> getCommandList() {
        ArrayList<Command> result = new ArrayList<Command>();
        if (this.handler != null) {
            this.handler.getCommandList().forEach(command -> result.add(new CommandWrapper((BinaryDataCommand)command)));
        }
        return result;
    }

    public long getCommandPosition() {
        return this.handler != null ? this.handler.getCommandPosition() : 0L;
    }

    public long getMaximumUndo() {
        return this.handler != null ? this.handler.getMaximumUndo() : 0L;
    }

    public long getSyncPoint() {
        return this.handler != null ? this.handler.getSyncPoint() : 0L;
    }

    public long getUndoMaximumSize() {
        return this.handler != null ? this.handler.getUndoMaximumSize() : 0L;
    }

    public long getUsedSize() {
        return this.handler != null ? this.handler.getUsedSize() : 0L;
    }

    public void performRedo() throws Exception {
        this.handler.performRedo();
    }

    public void performRedo(int i) throws Exception {
        this.handler.performRedo(i);
    }

    public void performUndo() throws Exception {
        this.handler.performUndo();
    }

    public void performUndo(int i) throws Exception {
        this.handler.performUndo(i);
    }

    public void setCommandPosition(long l) throws Exception {
        this.handler.setCommandPosition(l);
    }

    public void setSyncPoint(long l) {
        this.handler.setSyncPoint(l);
    }

    public void setSyncPoint() {
        this.handler.setSyncPoint();
    }

    public void addUndoUpdateListener(final XBUndoUpdateListener listener) {
        BinaryDataUndoUpdateListener binaryListener = new BinaryDataUndoUpdateListener(){

            public void undoCommandPositionChanged() {
                listener.undoCommandPositionChanged();
            }

            public void undoCommandAdded(BinaryDataCommand bdc) {
                listener.undoCommandAdded((Command)new CommandWrapper(bdc));
            }
        };
        this.listenersMap.put(listener, binaryListener);
        if (this.handler != null) {
            this.handler.addUndoUpdateListener(binaryListener);
        }
    }

    public void removeUndoUpdateListener(XBUndoUpdateListener listener) {
        BinaryDataUndoUpdateListener binaryListener = this.listenersMap.remove(listener);
        if (this.handler != null) {
            this.handler.removeUndoUpdateListener(binaryListener);
        }
    }

    @ParametersAreNonnullByDefault
    private static class BinaryCommandWrapper
    implements BinaryDataCommand {
        private final Command command;

        public BinaryCommandWrapper(Command command) {
            this.command = command;
        }

        @Nonnull
        public String getCaption() {
            return this.command.getCaption();
        }

        public void execute() throws BinaryDataOperationException {
            try {
                this.command.execute();
            }
            catch (Exception ex) {
                throw new BinaryDataOperationException((Throwable)ex);
            }
        }

        public void use() {
            this.command.use();
        }

        public void redo() throws BinaryDataOperationException {
            try {
                this.command.redo();
            }
            catch (Exception ex) {
                throw new BinaryDataOperationException((Throwable)ex);
            }
        }

        public void undo() throws BinaryDataOperationException {
            try {
                this.command.undo();
            }
            catch (Exception ex) {
                throw new BinaryDataOperationException((Throwable)ex);
            }
        }

        public boolean canUndo() {
            return this.command.canUndo();
        }

        public void dispose() throws BinaryDataOperationException {
            try {
                this.command.dispose();
            }
            catch (Exception ex) {
                throw new BinaryDataOperationException((Throwable)ex);
            }
        }

        @Nonnull
        public Optional<Date> getExecutionTime() {
            return this.command.getExecutionTime();
        }
    }

    @ParametersAreNonnullByDefault
    private static class CommandWrapper
    implements Command {
        private final BinaryDataCommand command;

        public CommandWrapper(BinaryDataCommand command) {
            this.command = command;
        }

        @Nonnull
        public String getCaption() {
            return this.command.getCaption();
        }

        public void execute() throws Exception {
            this.command.execute();
        }

        public void use() {
            this.command.use();
        }

        public void redo() throws Exception {
            this.command.redo();
        }

        public void undo() throws Exception {
            this.command.undo();
        }

        public boolean canUndo() {
            return this.command.canUndo();
        }

        public void dispose() throws Exception {
            this.command.dispose();
        }

        @Nonnull
        public Optional<Date> getExecutionTime() {
            return this.command.getExecutionTime();
        }
    }
}

