/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.EditMode;
import org.exbin.bined.EditOperation;
import org.exbin.bined.SelectionRange;

@ParametersAreNonnullByDefault
public interface BinaryStatusApi {
    public void setCursorPosition(CodeAreaCaretPosition var1);

    public void setSelectionRange(SelectionRange var1);

    public void setEditMode(EditMode var1, EditOperation var2);

    public void setCurrentDocumentSize(long var1, long var3);

    public void setMemoryMode(MemoryMode var1);

    @ParametersAreNonnullByDefault
    public static enum MemoryMode {
        READ_ONLY("R", "read_only"),
        RAM_MEMORY("M", "ram"),
        DELTA_MODE("\u0394", "delta");

        private final String displayChar;
        private final String value;

        private MemoryMode(String displayChar, String preferencesValue) {
            this.displayChar = displayChar;
            this.value = preferencesValue;
        }

        @Nonnull
        public String getDisplayChar() {
            return this.displayChar;
        }

        @Nonnull
        public String getPreferencesValue() {
            return this.value;
        }

        @Nullable
        public static MemoryMode findByPreferencesValue(String matchValue) {
            for (MemoryMode value : MemoryMode.values()) {
                if (!value.getPreferencesValue().equals(matchValue)) continue;
                return value;
            }
            return null;
        }
    }
}

