/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.visual.xbplugins;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSerializable;
import org.exbin.xbup.visual.picture.XBBufferedImage;
import org.exbin.xbup.visual.xbplugins.ImageFileFilter;

public class XBPicturePanel
extends JPanel
implements XBPSerializable {
    private final JFileChooser openFC;
    private final JFileChooser saveFC;
    private ChangeListener changeListener = null;
    private JButton exportButton;
    private JLabel imageLabel;
    private JScrollPane imageScrollPane;
    private JButton importButton;

    public XBPicturePanel() {
        String[] formats;
        this.initComponents();
        this.openFC = new JFileChooser();
        this.saveFC = new JFileChooser();
        for (String ext : formats = ImageIO.getReaderFormatNames()) {
            if (!ext.toLowerCase().equals(ext)) continue;
            ImageFileFilter filter = new ImageFileFilter(ext);
            this.openFC.addChoosableFileFilter(filter);
            this.saveFC.addChoosableFileFilter(filter);
        }
        this.openFC.setAcceptAllFileFilterUsed(true);
        this.saveFC.setAcceptAllFileFilterUsed(true);
        this.imageLabel.setIcon(new ImageIcon());
    }

    private void initComponents() {
        this.imageScrollPane = new JScrollPane();
        this.imageLabel = new JLabel();
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setAutoscrolls(true);
        this.imageLabel.setDoubleBuffered(true);
        this.imageScrollPane.setViewportView(this.imageLabel);
        this.importButton.setText("Import...");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBPicturePanel.this.importButtonActionPerformed(evt);
            }
        });
        this.exportButton.setText("Export...");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XBPicturePanel.this.exportButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.imageScrollPane, -1, 213, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.exportButton, -1, -1, Short.MAX_VALUE).addComponent(this.importButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageScrollPane, -1, 206, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButton))).addContainerGap()));
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        if (this.openFC.showOpenDialog(this) == 0) {
            this.imageLabel.setIcon(new ImageIcon(this.openFC.getSelectedFile().getAbsolutePath()));
            this.fireChangePerformed();
        }
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        if (this.saveFC.showSaveDialog(this) == 0) {
            try {
                File file = new File(this.saveFC.getSelectedFile().getAbsolutePath());
                String ext = "png";
                if (this.saveFC.getFileFilter() instanceof ImageFileFilter) {
                    ext = ((ImageFileFilter)this.saveFC.getFileFilter()).getExt();
                }
                ImageIO.write((RenderedImage)XBPicturePanel.toBufferedImage(((ImageIcon)this.imageLabel.getIcon()).getImage()), ext, file);
                this.imageLabel.setIcon(new ImageIcon(this.saveFC.getSelectedFile().getAbsolutePath()));
            }
            catch (IOException ex) {
                Logger.getLogger(XBPicturePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = XBPicturePanel.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public Icon getIcon() {
        return this.imageLabel.getIcon();
    }

    public void setIcon(Icon icon) {
        this.imageLabel.setIcon(icon);
    }

    public void serializeFromXB(XBPInputSerialHandler serializationHandler) throws XBProcessingException, IOException {
        XBBufferedImage image = new XBBufferedImage();
        serializationHandler.append((XBSerializable)image);
        ((ImageIcon)this.imageLabel.getIcon()).setImage(image.getImage());
    }

    public void serializeToXB(XBPOutputSerialHandler serializationHandler) throws XBProcessingException, IOException {
        XBBufferedImage bufferedImage = new XBBufferedImage(XBPicturePanel.toBufferedImage(((ImageIcon)this.imageLabel.getIcon()).getImage()));
        serializationHandler.append((XBSerializable)bufferedImage);
    }

    public void attachChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    public void fireChangePerformed() {
        if (this.changeListener != null) {
            this.changeListener.valueChanged();
        }
    }

    public static interface ChangeListener {
        public void valueChanged();
    }
}

