/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.service;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBERoot;
import org.exbin.xbup.catalog.entity.manager.XBERootManager;
import org.exbin.xbup.catalog.entity.service.XBEDefaultService;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.manager.XBCNodeManager;
import org.exbin.xbup.core.catalog.base.manager.XBCRootManager;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class XBERootService
extends XBEDefaultService<XBCRoot>
implements XBCRootService,
Serializable {
    @Autowired
    private XBERootManager manager;

    public XBERootService() {
    }

    public XBERootService(XBECatalog catalog) {
        super(catalog);
        this.itemManager = new XBERootManager(catalog);
        catalog.addCatalogManager(XBCRootManager.class, (XBCRootManager)this.itemManager);
    }

    @PostConstruct
    public void init() {
        this.itemManager = this.manager;
    }

    @Nonnull
    public XBERoot getMainRoot() {
        return ((XBERootManager)this.itemManager).getMainRoot();
    }

    @Nonnull
    public Optional<Date> getMainLastUpdate() {
        return ((XBERootManager)this.itemManager).getMainLastUpdate();
    }

    public boolean isMainPresent() {
        return ((XBERootManager)this.itemManager).isMainPresent();
    }

    public void setMainLastUpdate(Date updateDate) {
        ((XBERootManager)this.itemManager).setMainLastUpdate(updateDate);
    }

    public void setMainLastUpdateToNow() {
        ((XBERootManager)this.itemManager).setMainLastUpdateToNow();
    }

    public void removeAllForRoot(XBCRoot root) {
        XBCNode rootNode = root.getNode();
        XBCNodeManager nodeManager = this.catalog.getCatalogManager(XBCNodeManager.class);
        nodeManager.removeNodeFully(rootNode);
    }
}

