/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEXLanguage;
import org.exbin.xbup.catalog.entity.manager.DatabaseUtils;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.manager.XBCXLangManager;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBEXLangManager
extends XBEDefaultCatalogManager<XBCXLanguage>
implements XBCXLangManager,
Serializable {
    private XBEXLanguage defaultLanguageCache = null;

    public XBEXLangManager() {
    }

    public XBEXLangManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBEXLanguage.class;
    }

    public XBEXLanguage getDefaultLang() {
        if (this.defaultLanguageCache != null) {
            return this.defaultLanguageCache;
        }
        try {
            Query query = this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXLanguage as o");
            query.setMaxResults(1);
            this.defaultLanguageCache = (XBEXLanguage)query.getSingleResult();
            return this.defaultLanguageCache;
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXLangManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Nonnull
    public Optional<XBCXLanguage> findByCode(String langCode) {
        try {
            return Optional.of((XBEXLanguage)this.catalog.getEntityManager().createQuery("SELECT object(o) FROM XBXLanguage as o WHERE o.langCode = '" + DatabaseUtils.sqlEscapeString(langCode) + "'").getSingleResult());
        }
        catch (NoResultException ex) {
            return Optional.empty();
        }
        catch (Exception ex) {
            Logger.getLogger(XBEXLangManager.class.getName()).log(Level.SEVERE, null, ex);
            return Optional.empty();
        }
    }

    public void initializeExtension() {
    }

    @Nonnull
    public String getExtensionName() {
        return "Language Extension";
    }

    @Override
    public boolean initCatalog() {
        XBEXLanguage lang = new XBEXLanguage();
        lang.setLangCode("en");
        this.em.persist((Object)lang);
        return true;
    }
}

