/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.entity.manager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.persistence.Query;
import org.exbin.xbup.catalog.XBECatalog;
import org.exbin.xbup.catalog.entity.XBEItem;
import org.exbin.xbup.catalog.entity.XBEXDesc;
import org.exbin.xbup.catalog.entity.XBEXName;
import org.exbin.xbup.catalog.entity.XBEXStri;
import org.exbin.xbup.catalog.entity.manager.XBEDefaultCatalogManager;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.manager.XBCItemManager;
import org.exbin.xbup.core.catalog.base.manager.XBCXLangManager;
import org.exbin.xbup.core.catalog.base.service.XBItemWithDetail;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class XBEItemManager
extends XBEDefaultCatalogManager<XBCItem>
implements XBCItemManager,
Serializable {
    public XBEItemManager() {
    }

    public XBEItemManager(XBECatalog catalog) {
        super(catalog);
    }

    @Override
    @Nonnull
    public Class getEntityClass() {
        return XBEItem.class;
    }

    @Nonnull
    public List<XBItemWithDetail> findAllPaged(int startFrom, int maxResults, @Nullable String filterCondition, @Nullable String orderCondition, @Nullable String specType) {
        XBCXLangManager langManager = this.catalog.getCatalogManager(XBCXLangManager.class);
        long languageId = langManager.getDefaultLang().getId();
        if (orderCondition == null) {
            orderCondition = "item.id";
        }
        Query query = this.em.createQuery("SELECT item, name, dsc, stri FROM " + (specType == null ? "XBItem" : specType) + " item LEFT JOIN XBXName name ON name.item = item AND name.lang.id = " + languageId + " LEFT JOIN XBXDesc dsc ON dsc.item = item AND name.lang.id = " + languageId + " LEFT JOIN XBXStri stri ON stri.item = item" + (filterCondition == null || filterCondition.isEmpty() ? "" : " WHERE " + filterCondition) + " ORDER BY " + orderCondition);
        query.setFirstResult(startFrom);
        query.setMaxResults(maxResults);
        ArrayList<XBItemWithDetail> results = new ArrayList<XBItemWithDetail>();
        for (Object row : query.getResultList()) {
            XBItemWithDetail itemRecord = new XBItemWithDetail();
            itemRecord.setItem((XBCItem)((XBEItem)((Object[])row)[0]));
            XBEXName name = (XBEXName)((Object[])row)[1];
            itemRecord.setName(name == null ? null : name.getText());
            XBEXDesc desc = (XBEXDesc)((Object[])row)[2];
            itemRecord.setDescription(desc == null ? null : desc.getText());
            XBEXStri stri = (XBEXStri)((Object[])row)[3];
            itemRecord.setStringId(stri == null ? null : stri.getText());
            results.add(itemRecord);
        }
        return results;
    }

    public int findAllPagedCount(@Nullable String filterCondition, @Nullable String specType) {
        XBCXLangManager langManager = this.catalog.getCatalogManager(XBCXLangManager.class);
        long languageId = langManager.getDefaultLang().getId();
        String filterPrefix = "";
        String filterPostfix = "";
        if (filterCondition != null) {
            if (filterCondition.contains("name.")) {
                filterPrefix = filterPrefix + "XBXName name";
                filterPostfix = filterPostfix + " AND name.item = item AND name.lang.id = " + languageId;
            }
            if (filterCondition.contains("desc.")) {
                if (!filterPrefix.isEmpty()) {
                    filterPrefix = filterPrefix + ", ";
                }
                filterPrefix = filterPrefix + "XBXDesc dsc";
                filterPostfix = filterPostfix + " AND dsc.item = item AND dsc.lang.id = " + languageId;
            }
            if (filterCondition.contains("stri.")) {
                if (!filterPrefix.isEmpty()) {
                    filterPrefix = filterPrefix + ", ";
                }
                filterPrefix = filterPrefix + "XBXStri stri";
                filterPostfix = filterPostfix + " AND stri.item = item";
            }
            if (!filterPrefix.isEmpty()) {
                filterPrefix = "EXISTS(SELECT 1 FROM " + filterPrefix + " WHERE ";
                filterPostfix = filterPostfix + ")";
            }
        }
        Query query = this.em.createQuery("SELECT COUNT(item) FROM " + (specType == null ? "XBItem" : specType) + " item" + (filterCondition == null || filterCondition.isEmpty() ? "" : " WHERE ") + filterPrefix + filterCondition + filterPostfix);
        return ((Long)query.getSingleResult()).intValue();
    }
}

