/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.catalog.convert;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.exbin.xbup.catalog.entity.XBEBlockSpec;
import org.exbin.xbup.catalog.entity.XBEFormatSpec;
import org.exbin.xbup.catalog.entity.XBEGroupSpec;
import org.exbin.xbup.catalog.entity.XBEItem;
import org.exbin.xbup.catalog.entity.XBENode;
import org.exbin.xbup.catalog.entity.XBERev;
import org.exbin.xbup.catalog.entity.XBESpec;
import org.exbin.xbup.catalog.entity.XBESpecDef;
import org.exbin.xbup.catalog.entity.service.XBEXDescService;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.catalog.entity.service.XBEXStriService;
import org.exbin.xbup.core.block.definition.XBParamType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.XBCBlockSpec;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupSpec;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.service.XBCNodeService;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXHDocService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.catalog.base.service.XBCXStriService;
import org.yaml.snakeyaml.Yaml;

public class XBCatalogYaml {
    private XBACatalog catalog;
    private XBCXNameService nameService;
    private XBCXDescService descService;

    public void exportCatalogItem(XBCItem item, Writer writer) {
        HashMap<String, Object> itemData = new HashMap<String, Object>();
        if (item instanceof XBCNode) {
            this.exportNode((XBCNode)item, itemData);
        } else {
            this.exportItem(item, itemData);
            if (item instanceof XBCSpec) {
                this.exportSpec((XBCItem)((XBCSpec)item), itemData);
            }
        }
        ArrayList<HashMap<String, Object>> itemMaps = new ArrayList<HashMap<String, Object>>();
        itemMaps.add(itemData);
        HashMap<String, ArrayList<HashMap<String, Object>>> doc = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        String typeString = this.getItemTypeString(item);
        doc.put(typeString, itemMaps);
        Yaml yaml = new Yaml();
        yaml.dump(doc, writer);
    }

    public void exportItem(XBCItem item, Map<String, Object> targetData) {
        String hdoc;
        String desc;
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCXHDocService hdocService = (XBCXHDocService)this.catalog.getCatalogService(XBCXHDocService.class);
        String stringId = striService.getItemStringIdText(item);
        targetData.put("id", stringId);
        String name = this.nameService.getDefaultText(item);
        if (name != null) {
            targetData.put("name", name);
        }
        if ((desc = this.descService.getDefaultText(item)) != null) {
            targetData.put("description", desc);
        }
        if ((hdoc = hdocService.getDocumentationText(item)) != null) {
            targetData.put("HDoc", hdoc);
        }
    }

    public void exportSpec(XBCItem item, Map<String, Object> targetData) {
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        ArrayList defs = new ArrayList();
        List specDefs = specService.getSpecDefs((XBCSpec)item);
        for (XBCSpecDef specDef : specDefs) {
            HashMap<String, Object> def = new HashMap<String, Object>();
            String name = striService.getItemStringIdText((XBCItem)specDef);
            def.put("id", name);
            def.put("bind", this.getBindString(specDef.getType()));
            Optional optionalTargetRev = specDef.getTargetRev();
            if (optionalTargetRev.isPresent()) {
                XBCRev targetRev = (XBCRev)optionalTargetRev.get();
                String type = striService.getItemFullPath((XBCItem)targetRev.getParent());
                def.put("type", type);
                Long rev = targetRev.getXBIndex();
                def.put("rev", rev);
            }
            HashMap<String, Object> defData = new HashMap<String, Object>();
            this.exportItem((XBCItem)specDef, defData);
            def.putAll(defData);
            defs.add(def);
        }
        targetData.put("def", defs);
    }

    public void exportNode(XBCNode node, Map<String, Object> targetData) {
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        this.exportItem((XBCItem)node, targetData);
        ArrayList<Object> blockSpecMaps = new ArrayList<Object>();
        List blockSpecs = specService.getBlockSpecs(node);
        for (XBCBlockSpec blockSpec : blockSpecs) {
            HashMap<String, Object> specData = new HashMap<String, Object>();
            this.exportItem((XBCItem)blockSpec, specData);
            this.exportSpec((XBCItem)blockSpec, specData);
            blockSpecMaps.add(specData);
        }
        targetData.put("block", blockSpecMaps);
        ArrayList<Object> groupSpecMaps = new ArrayList<Object>();
        List groupSpecs = specService.getGroupSpecs(node);
        for (XBCGroupSpec groupSpec : groupSpecs) {
            HashMap<String, Object> specData = new HashMap<String, Object>();
            this.exportItem((XBCItem)groupSpec, specData);
            this.exportSpec((XBCItem)groupSpec, specData);
            groupSpecMaps.add(specData);
        }
        targetData.put("group", groupSpecMaps);
        ArrayList<HashMap<String, Object>> formatSpecMaps = new ArrayList<HashMap<String, Object>>();
        List formatSpecs = specService.getFormatSpecs(node);
        for (XBCFormatSpec formatSpec : formatSpecs) {
            HashMap<String, Object> specData = new HashMap<String, Object>();
            this.exportItem((XBCItem)formatSpec, specData);
            this.exportSpec((XBCItem)formatSpec, specData);
            formatSpecMaps.add(specData);
        }
        targetData.put("format", formatSpecMaps);
        ArrayList<HashMap<String, Object>> nodeSpecMaps = new ArrayList<HashMap<String, Object>>();
        List subNodes = nodeService.getSubNodes(node);
        for (XBCNode subNode : subNodes) {
            HashMap<String, Object> subNodeData = new HashMap<String, Object>();
            this.exportNode(subNode, subNodeData);
            nodeSpecMaps.add(subNodeData);
        }
        targetData.put("node", nodeSpecMaps);
    }

    public void importCatalogItem(InputStream stream, XBENode parentNode) {
        Yaml yaml = new Yaml();
        Object doc = yaml.load(stream);
        this.importNode((Map)doc, parentNode);
    }

    public void importItem(Map<String, Object> blockData, XBEItem target) {
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBCXHDocService hdocService = (XBCXHDocService)this.catalog.getCatalogService(XBCXHDocService.class);
        String stringId = (String)blockData.get("id");
        ((XBEXStriService)striService).setItemStringIdText(target, stringId);
        String name = (String)blockData.get("name");
        ((XBEXNameService)this.nameService).setDefaultText(target, name);
        String desc = (String)blockData.get("description");
        ((XBEXDescService)this.descService).setDefaultText(target, desc);
    }

    public void importSpec(Map<String, Object> specData, XBESpec target) {
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
        XBCXStriService striService = (XBCXStriService)this.catalog.getCatalogService(XBCXStriService.class);
        XBEBlockSpec blockSpec = (XBEBlockSpec)specService.createBlockSpec();
        specService.persistItem((XBCBase)blockSpec);
        this.importItem(specData, blockSpec);
        List defs = (List)specData.get("def");
        for (int defId = 0; defId < defs.size(); ++defId) {
            Map def = (Map)defs.get(defId);
            String bind = (String)def.get("bind");
            XBParamType bindType = this.getBindType(bind);
            XBESpecDef specDef = (XBESpecDef)specService.createSpecDef((XBCSpec)blockSpec, bindType);
            specService.persistSpecDef((XBCSpecDef)specDef);
            this.importItem(def, specDef);
            specDef.setXBIndex(defId);
            String type = (String)def.get("type");
            XBCSpec targetSpec = striService.getSpecByFullPath(type);
            if (targetSpec != null) {
                Integer targetRevIndex = (Integer)def.get("rev");
                XBERev targetRev = (XBERev)revService.findRevByXB(targetSpec, (long)targetRevIndex.intValue());
                specDef.setTargetRev(targetRev);
            }
            specService.persistSpecDef((XBCSpecDef)specDef);
        }
        specService.persistItem((XBCBase)blockSpec);
    }

    public void importNode(Map<String, Object> nodeData, XBENode target) {
        List formats;
        List groups;
        List blocks;
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        XBCNodeService nodeService = (XBCNodeService)this.catalog.getCatalogService(XBCNodeService.class);
        List nodes = (List)nodeData.get("node");
        if (nodes != null) {
            for (Object node : nodes) {
                Map subNodeData = (Map)node;
                XBENode subNode = (XBENode)nodeService.createItem();
                subNode.setParent(target);
                nodeService.persistItem((XBCBase)subNode);
                this.importItem(subNodeData, subNode);
                this.importNode(subNodeData, subNode);
            }
        }
        if ((blocks = (List)nodeData.get("block")) != null && nodes != null) {
            for (int blockId = 0; blockId < blocks.size(); ++blockId) {
                Map blockData = (Map)nodes.get(blockId);
                XBEBlockSpec blockSpec = (XBEBlockSpec)specService.createBlockSpec();
                blockSpec.setParentItem(target);
                long blockSpecIndex = specService.findMaxBlockSpecXB((XBCNode)target);
                blockSpec.setXBIndex(++blockSpecIndex);
                specService.persistItem((XBCBase)blockSpec);
                this.importItem(blockData, blockSpec);
                this.importSpec(blockData, blockSpec);
            }
        }
        if ((groups = (List)nodeData.get("group")) != null && nodes != null) {
            for (int groupId = 0; groupId < groups.size(); ++groupId) {
                Map groupData = (Map)nodes.get(groupId);
                XBEGroupSpec groupSpec = (XBEGroupSpec)specService.createGroupSpec();
                groupSpec.setParentItem(target);
                long groupSpecIndex = specService.findMaxGroupSpecXB((XBCNode)target);
                groupSpec.setXBIndex(++groupSpecIndex);
                specService.persistItem((XBCBase)groupSpec);
                this.importItem(groupData, groupSpec);
                this.importSpec(groupData, groupSpec);
            }
        }
        if ((formats = (List)nodeData.get("format")) != null && nodes != null) {
            for (int formatId = 0; formatId < formats.size(); ++formatId) {
                Map formatData = (Map)nodes.get(formatId);
                XBEFormatSpec formatSpec = (XBEFormatSpec)specService.createFormatSpec();
                formatSpec.setParentItem(target);
                long formatSpecIndex = specService.findMaxFormatSpecXB((XBCNode)target);
                formatSpec.setXBIndex(++formatSpecIndex);
                specService.persistItem((XBCBase)formatSpec);
                this.importItem(formatData, formatSpec);
                this.importSpec(formatData, formatSpec);
            }
        }
    }

    private String getBindString(XBParamType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case CONSIST: {
                return "cons";
            }
            case JOIN: {
                return "join";
            }
            case LIST_CONSIST: {
                return "listcons";
            }
            case LIST_JOIN: {
                return "listjoin";
            }
        }
        return null;
    }

    private XBParamType getBindType(String bind) {
        if ("join".equals(bind)) {
            return XBParamType.JOIN;
        }
        if ("cons".equals(bind)) {
            return XBParamType.CONSIST;
        }
        if ("listcons".equals(bind)) {
            return XBParamType.LIST_CONSIST;
        }
        if ("listjoin".equals(bind)) {
            return XBParamType.LIST_JOIN;
        }
        return null;
    }

    private String getItemTypeString(XBCItem item) {
        if (item instanceof XBCNode) {
            return "node";
        }
        if (item instanceof XBCBlockSpec) {
            return "block";
        }
        if (item instanceof XBCGroupSpec) {
            return "group";
        }
        if (item instanceof XBCFormatSpec) {
            return "format";
        }
        return null;
    }

    private Class getItemStringType(String itemType) {
        if ("node".equals(itemType)) {
            return XBCNode.class;
        }
        if ("block".equals(itemType)) {
            return XBCBlockSpec.class;
        }
        if ("group".equals(itemType)) {
            return XBCGroupSpec.class;
        }
        if ("format".equals(itemType)) {
            return XBCFormatSpec.class;
        }
        return null;
    }

    public void setCatalog(XBACatalog catalog) {
        this.catalog = catalog;
        this.nameService = catalog == null ? null : (XBCXNameService)catalog.getCatalogService(XBCXNameService.class);
        this.descService = catalog == null ? null : (XBCXDescService)catalog.getCatalogService(XBCXDescService.class);
    }
}

