/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.EditMode;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.diff.DiffHighlightCodeAreaPainter;

@ParametersAreNonnullByDefault
public class ExtCodeAreaDiffPanel
extends JPanel {
    private final ExtCodeArea leftCodeArea;
    private final ExtCodeArea rightCodeArea;
    private final DiffHighlightCodeAreaPainter leftPainter;
    private final DiffHighlightCodeAreaPainter rightPainter;
    private volatile boolean updatingScrolling = false;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JSplitPane splitPane;

    public ExtCodeAreaDiffPanel() {
        this.initComponents();
        this.leftCodeArea = new ExtCodeArea();
        this.rightCodeArea = new ExtCodeArea();
        this.leftPainter = new DiffHighlightCodeAreaPainter(this.leftCodeArea);
        this.rightPainter = new DiffHighlightCodeAreaPainter(this.rightCodeArea);
        this.init();
    }

    private void init() {
        this.leftCodeArea.setEditMode(EditMode.READ_ONLY);
        this.rightCodeArea.setEditMode(EditMode.READ_ONLY);
        this.leftCodeArea.setPainter(this.leftPainter);
        this.rightCodeArea.setPainter(this.rightPainter);
        this.leftPanel.add((Component)((Object)this.leftCodeArea), "Center");
        this.rightPanel.add((Component)((Object)this.rightCodeArea), "Center");
        this.leftCodeArea.addScrollingListener(() -> {
            if (!this.updatingScrolling) {
                this.updatingScrolling = true;
                CodeAreaScrollPosition currentScrollPosition = this.rightCodeArea.getScrollPosition();
                CodeAreaScrollPosition scrollPosition = this.leftCodeArea.getScrollPosition();
                long maxRowPosition = this.rightCodeArea.getDataSize() / (long)this.rightCodeArea.getMaxBytesPerRow();
                if (scrollPosition.getRowPosition() > maxRowPosition) {
                    if (currentScrollPosition.getRowPosition() >= maxRowPosition) {
                        this.updatingScrolling = false;
                        return;
                    }
                    scrollPosition.setRowPosition(maxRowPosition);
                }
                this.rightCodeArea.setScrollPosition(scrollPosition);
                this.updatingScrolling = false;
            }
        });
        this.rightCodeArea.addScrollingListener(() -> {
            if (!this.updatingScrolling) {
                this.updatingScrolling = true;
                CodeAreaScrollPosition currentScrollPosition = this.leftCodeArea.getScrollPosition();
                CodeAreaScrollPosition scrollPosition = this.rightCodeArea.getScrollPosition();
                long maxRowPosition = this.leftCodeArea.getDataSize() / (long)this.leftCodeArea.getMaxBytesPerRow();
                if (scrollPosition.getRowPosition() > maxRowPosition) {
                    if (currentScrollPosition.getRowPosition() >= maxRowPosition) {
                        this.updatingScrolling = false;
                        return;
                    }
                    scrollPosition.setRowPosition(maxRowPosition);
                }
                this.leftCodeArea.setScrollPosition(scrollPosition);
                this.updatingScrolling = false;
            }
        });
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.leftPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.splitPane.setDividerLocation(300);
        this.splitPane.setResizeWeight(0.5);
        this.leftPanel.setLayout(new BorderLayout());
        this.splitPane.setLeftComponent(this.leftPanel);
        this.rightPanel.setLayout(new BorderLayout());
        this.splitPane.setRightComponent(this.rightPanel);
        this.add((Component)this.splitPane, "Center");
    }

    @Nonnull
    public ExtCodeArea getLeftCodeArea() {
        return this.leftCodeArea;
    }

    @Nonnull
    public ExtCodeArea getRightCodeArea() {
        return this.rightCodeArea;
    }

    public void setLeftContentData(BinaryData contentData) {
        this.leftCodeArea.setContentData(contentData);
        this.rightPainter.setComparedData(contentData);
    }

    public void setRightContentData(BinaryData contentData) {
        this.rightCodeArea.setContentData(contentData);
        this.leftPainter.setComparedData(contentData);
    }
}

