/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.exbin.bined.basic.ScrollBarVerticalScale;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.extended.ExtendedCodeAreaStructure;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;
import org.exbin.bined.swing.extended.ExtendedCodeAreaDimensions;
import org.exbin.bined.swing.extended.ExtendedCodeAreaScrolling;

@ParametersAreNonnullByDefault
public class ExtendedCodeAreaScrollPane
extends JScrollPane {
    private volatile boolean scrollingByUser = false;
    private volatile boolean scrollingUpdate = false;
    @Nonnull
    private final VerticalScrollBarModel verticalScrollBarModel = new VerticalScrollBarModel();
    @Nonnull
    private final HorizontalScrollBarModel horizontalScrollBarModel = new HorizontalScrollBarModel();
    @Nonnull
    private final CodeAreaSwingControl control;
    @Nonnull
    private final BasicCodeAreaMetrics metrics;
    @Nonnull
    private final ExtendedCodeAreaStructure structure;
    @Nonnull
    private final ExtendedCodeAreaScrolling scrolling;
    @Nonnull
    private final ExtendedCodeAreaDimensions dimensions;

    public ExtendedCodeAreaScrollPane(CodeAreaSwingControl control, BasicCodeAreaMetrics metrics, ExtendedCodeAreaStructure structure, ExtendedCodeAreaScrolling scrolling, ExtendedCodeAreaDimensions dimensions) {
        this.control = control;
        this.metrics = metrics;
        this.structure = structure;
        this.dimensions = dimensions;
        this.scrolling = scrolling;
        this.init();
    }

    private void init() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setIgnoreRepaint(true);
        this.setOpaque(false);
        this.setInheritsPopupMenu(true);
        this.setViewportBorder(null);
        this.verticalScrollBar.setIgnoreRepaint(true);
        this.verticalScrollBar.addAdjustmentListener(new VerticalAdjustmentListener());
        this.verticalScrollBar.setModel(this.verticalScrollBarModel);
        this.verticalScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = false;
                }
            }
        });
        this.horizontalScrollBar.setIgnoreRepaint(true);
        this.horizontalScrollBar.addAdjustmentListener(new HorizontalAdjustmentListener());
        this.horizontalScrollBar.setModel(this.horizontalScrollBarModel);
        this.horizontalScrollBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = false;
                }
            }
        });
    }

    @Override
    @Nonnull
    public JScrollBar createVerticalScrollBar() {
        return new JScrollPane.ScrollBar(1){

            @Override
            public void setValue(int value) {
                if (!ExtendedCodeAreaScrollPane.this.scrollingUpdate && !ExtendedCodeAreaScrollPane.this.scrollingByUser) {
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = true;
                    super.setValue(value);
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = false;
                } else {
                    super.setValue(value);
                }
            }
        };
    }

    @Override
    @Nonnull
    public JScrollBar createHorizontalScrollBar() {
        return new JScrollPane.ScrollBar(0){

            @Override
            public void setValue(int value) {
                if (!ExtendedCodeAreaScrollPane.this.scrollingUpdate && !ExtendedCodeAreaScrollPane.this.scrollingByUser) {
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = true;
                    super.setValue(value);
                    ExtendedCodeAreaScrollPane.this.scrollingByUser = false;
                } else {
                    super.setValue(value);
                }
            }
        };
    }

    public void horizontalExtentChanged() {
        this.horizontalScrollBarModel.notifyChanged();
    }

    public void verticalExtentChanged() {
        this.verticalScrollBarModel.notifyChanged();
    }

    public void updateScrollBars(int verticalScrollValue, int horizontalScrollValue) {
        this.scrollingUpdate = true;
        this.verticalScrollBar.setValue(verticalScrollValue);
        this.horizontalScrollBar.setValue(horizontalScrollValue);
        this.scrollingUpdate = false;
    }

    private class HorizontalAdjustmentListener
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(@Nullable AdjustmentEvent e) {
            if (e == null || !ExtendedCodeAreaScrollPane.this.scrollingByUser || ExtendedCodeAreaScrollPane.this.scrollingUpdate) {
                return;
            }
            int scrollBarValue = ExtendedCodeAreaScrollPane.this.horizontalScrollBar.getValue();
            ExtendedCodeAreaScrollPane.this.scrolling.updateHorizontalScrollBarValue(scrollBarValue, ExtendedCodeAreaScrollPane.this.metrics.getCharacterWidth());
            ExtendedCodeAreaScrollPane.this.control.updateScrollPosition(ExtendedCodeAreaScrollPane.this.scrolling.getScrollPosition());
        }
    }

    private class VerticalAdjustmentListener
    implements AdjustmentListener {
        private boolean wasAdjusting = false;

        @Override
        public void adjustmentValueChanged(@Nullable AdjustmentEvent e) {
            if (e == null || ExtendedCodeAreaScrollPane.this.scrollingUpdate) {
                return;
            }
            if (!e.getValueIsAdjusting()) {
                if (this.wasAdjusting) {
                    this.wasAdjusting = false;
                } else {
                    int lastValue = ExtendedCodeAreaScrollPane.this.scrolling.getLastVerticalScrollingValue();
                    if (ExtendedCodeAreaScrollPane.this.scrollingByUser && ExtendedCodeAreaScrollPane.this.scrolling.getScrollBarVerticalScale() == ScrollBarVerticalScale.SCALED && lastValue != -1) {
                        if (e.getValue() == lastValue - 1 || lastValue == 0 && e.getValue() == 0) {
                            SwingUtilities.invokeLater(() -> {
                                ExtendedCodeAreaScrollPane.this.scrolling.performScrolling(ScrollingDirection.UP, ExtendedCodeAreaScrollPane.this.dimensions.getRowsPerPage(), ExtendedCodeAreaScrollPane.this.structure.getRowsPerDocument());
                                ExtendedCodeAreaScrollPane.this.control.updateScrollPosition(ExtendedCodeAreaScrollPane.this.scrolling.getScrollPosition());
                            });
                            return;
                        }
                        int maxScroll = ExtendedCodeAreaScrollPane.this.verticalScrollBarModel.getMaximum() - ExtendedCodeAreaScrollPane.this.verticalScrollBarModel.getExtent();
                        if (e.getValue() == lastValue + 1 || lastValue == maxScroll && e.getValue() == maxScroll) {
                            SwingUtilities.invokeLater(() -> {
                                ExtendedCodeAreaScrollPane.this.scrolling.performScrolling(ScrollingDirection.DOWN, ExtendedCodeAreaScrollPane.this.dimensions.getRowsPerPage(), ExtendedCodeAreaScrollPane.this.structure.getRowsPerDocument());
                                ExtendedCodeAreaScrollPane.this.control.updateScrollPosition(ExtendedCodeAreaScrollPane.this.scrolling.getScrollPosition());
                            });
                            return;
                        }
                    }
                }
            } else {
                this.wasAdjusting = true;
            }
            if (ExtendedCodeAreaScrollPane.this.scrollingByUser) {
                int scrollBarValue = ExtendedCodeAreaScrollPane.this.verticalScrollBar.getValue();
                int maxValue = Integer.MAX_VALUE - ExtendedCodeAreaScrollPane.this.verticalScrollBar.getVisibleAmount();
                long rowsPerDocumentToLastPage = ExtendedCodeAreaScrollPane.this.structure.getRowsPerDocument() - (long)ExtendedCodeAreaScrollPane.this.dimensions.getRowsPerRect();
                ExtendedCodeAreaScrollPane.this.scrolling.updateVerticalScrollBarValue(scrollBarValue, ExtendedCodeAreaScrollPane.this.metrics.getRowHeight(), maxValue, rowsPerDocumentToLastPage);
                ExtendedCodeAreaScrollPane.this.control.updateScrollPosition(ExtendedCodeAreaScrollPane.this.scrolling.getScrollPosition());
            }
        }
    }

    private class HorizontalScrollBarModel
    extends DefaultBoundedRangeModel {
        @Override
        public int getExtent() {
            return super.getExtent() - ExtendedCodeAreaScrollPane.this.scrolling.getHorizontalExtentDifference();
        }

        @Override
        public int getMaximum() {
            return super.getMaximum() - ExtendedCodeAreaScrollPane.this.scrolling.getHorizontalExtentDifference();
        }

        public void notifyChanged() {
            this.fireStateChanged();
        }
    }

    private class VerticalScrollBarModel
    extends DefaultBoundedRangeModel {
        private volatile int depth = 0;

        @Override
        public int getExtent() {
            return super.getExtent() - ExtendedCodeAreaScrollPane.this.scrolling.getVerticalExtentDifference();
        }

        @Override
        public int getMaximum() {
            return super.getMaximum() - ExtendedCodeAreaScrollPane.this.scrolling.getVerticalExtentDifference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
            super.setRangeProperties(newValue, newExtent, newMin, newMax, adjusting);
            if (!(ExtendedCodeAreaScrollPane.this.scrollingUpdate || newValue != ExtendedCodeAreaScrollPane.this.scrolling.getLastVerticalScrollingValue() || newValue > newMin && newValue < newMax - newExtent)) {
                ++this.depth;
                try {
                    if (this.depth < 5) {
                        this.fireStateChanged();
                    }
                }
                finally {
                    --this.depth;
                }
            }
        }

        @Override
        public void setValue(int n) {
            ExtendedCodeAreaScrollPane.this.scrolling.setLastVerticalScrollingValue(this.getValue());
            super.setValue(n);
        }

        public void notifyChanged() {
            this.fireStateChanged();
        }
    }
}

