/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.audio.xbplugins;

import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class AudioFileFilter
extends FileFilter {
    public static final String AUDIO_FILE_TYPE = "AudioFileFilter";
    private String ext;

    public AudioFileFilter(String ext) {
        this.ext = ext;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = AudioFileFilter.getExtension(f);
        if (extension != null) {
            return extension.toLowerCase(Locale.getDefault()).equals(this.getExt());
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Audio files " + this.getExt().toUpperCase(Locale.getDefault()) + " (*." + this.getExt() + ")";
    }

    public String getFileTypeId() {
        return "AudioFileFilter." + this.ext;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public static String getExtension(File f) {
        String ext = null;
        String str = f.getName();
        int extPos = str.lastIndexOf(46);
        if (extPos > 0 && extPos < str.length() - 1) {
            ext = str.substring(extPos + 1).toLowerCase(Locale.getDefault());
        }
        return ext;
    }
}

