/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ToolColorPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ToolColorPanel.class);
    private JColorChooser colorChooser;
    private JButton fillColorSelectButton;
    private JLabel fillcolorLabel;
    private JLabel penColorLabel;
    private JButton penColorSelectButton;
    private JPanel selectionColorPanel;
    private JPanel toolColorPanel;

    public ToolColorPanel() {
        this.initComponents();
    }

    public Color getToolColor() {
        return this.toolColorPanel.getBackground();
    }

    public Color getSelectionColor() {
        return this.selectionColorPanel.getBackground();
    }

    public void setToolColor(Color color) {
        this.toolColorPanel.setBackground(color);
    }

    public void setSelectionColor(Color color) {
        this.selectionColorPanel.setBackground(color);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.fillColorSelectButton.setEnabled(b);
        this.penColorSelectButton.setEnabled(b);
    }

    private void initComponents() {
        this.colorChooser = new JColorChooser();
        this.penColorLabel = new JLabel();
        this.toolColorPanel = new JPanel();
        this.penColorSelectButton = new JButton();
        this.fillcolorLabel = new JLabel();
        this.selectionColorPanel = new JPanel();
        this.fillColorSelectButton = new JButton();
        this.colorChooser.setName("colorChooser");
        this.setName("Form");
        this.penColorLabel.setText(this.resourceBundle.getString("penColorLabel.text"));
        this.penColorLabel.setName("penColorLabel");
        this.toolColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.toolColorPanel.setName("toolColorPanel");
        GroupLayout toolColorPanelLayout = new GroupLayout(this.toolColorPanel);
        this.toolColorPanel.setLayout(toolColorPanelLayout);
        toolColorPanelLayout.setHorizontalGroup(toolColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        toolColorPanelLayout.setVerticalGroup(toolColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.penColorSelectButton.setText(this.resourceBundle.getString("penColorSelectButton"));
        this.penColorSelectButton.setName("penColorSelectButton");
        this.penColorSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolColorPanel.this.penColorSelectButtonActionPerformed(evt);
            }
        });
        this.fillcolorLabel.setText(this.resourceBundle.getString("fillColorLabel"));
        this.fillcolorLabel.setName("fillcolorLabel");
        this.selectionColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.selectionColorPanel.setName("selectionColorPanel");
        GroupLayout selectionColorPanelLayout = new GroupLayout(this.selectionColorPanel);
        this.selectionColorPanel.setLayout(selectionColorPanelLayout);
        selectionColorPanelLayout.setHorizontalGroup(selectionColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        selectionColorPanelLayout.setVerticalGroup(selectionColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.fillColorSelectButton.setText(this.resourceBundle.getString("fillColorSelectButton"));
        this.fillColorSelectButton.setName("fillColorSelectButton");
        this.fillColorSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolColorPanel.this.fillColorSelectButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.selectionColorPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.penColorSelectButton, GroupLayout.Alignment.TRAILING).addComponent(this.fillColorSelectButton, GroupLayout.Alignment.TRAILING)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.penColorLabel).addComponent(this.fillcolorLabel)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.penColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolColorPanel, -2, -1, -2)).addComponent(this.penColorSelectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fillcolorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectionColorPanel, -2, -1, -2).addComponent(this.fillColorSelectButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void penColorSelectButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.toolColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, "Select color", true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolColorPanel.this.setToolColor(ToolColorPanel.this.colorChooser.getColor());
            }
        }, null);
        dialog.setVisible(true);
    }

    private void fillColorSelectButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.selectionColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, "Select color", true, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolColorPanel.this.setSelectionColor(ToolColorPanel.this.colorChooser.getColor());
            }
        }, null);
        dialog.setVisible(true);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ToolColorPanel());
    }
}

