/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.exbin.framework.editor.picture.gui.ImageStatusPanel;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdateListener;

public class ImagePanel
extends JPanel
implements ClipboardActionsHandler {
    private final UndoManager undo;
    private final boolean modified = false;
    private Image image;
    private Graphics graphics;
    private double scaleRatio;
    private final Object highlight;
    private Color selectionColor;
    private Color toolColor;
    private Font defaultFont;
    private Color[] defaultColors;
    private InputMethodListener caretListener;
    private final ToolMode toolMode;
    private ImageStatusPanel imageStatusPanel;
    private final ImageAreaPanel imageArea;
    private JScrollPane scrollPane;

    public ImagePanel() {
        this.initComponents();
        this.imageArea = new ImageAreaPanel();
        this.imageArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ImagePanel.this.imageAreaMouseClicked(evt);
            }
        });
        this.imageArea.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ImagePanel.this.imageAreaMouseDragged(evt);
            }
        });
        this.scrollPane.setViewportView(this.imageArea);
        this.scaleRatio = 1.0;
        this.toolMode = ToolMode.DOTTER;
        this.undo = new UndoManager();
        this.highlight = null;
        this.toolColor = Color.BLACK;
        this.selectionColor = Color.YELLOW;
        this.imageArea.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ImagePanel.this.undo.canUndo()) {
                        ImagePanel.this.undo.undo();
                    }
                }
                catch (CannotUndoException ex) {
                    Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.imageArea.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.imageArea.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ImagePanel.this.undo.canRedo()) {
                        ImagePanel.this.undo.redo();
                    }
                }
                catch (CannotRedoException ex) {
                    Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.imageArea.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.imageArea.addMouseWheelListener(e -> {
            int relativeMouseX = e.getPoint().x - this.scrollPane.getHorizontalScrollBar().getValue();
            int relativeMouseY = e.getPoint().y - this.scrollPane.getVerticalScrollBar().getValue();
            int positionX = (int)((double)e.getPoint().x * this.scaleRatio);
            int positionY = (int)((double)e.getPoint().y * this.scaleRatio);
            if (e.getWheelRotation() == 1) {
                this.setScale(this.scaleRatio * 2.0);
                positionX -= (int)((double)relativeMouseX * this.scaleRatio);
                positionY -= (int)((double)relativeMouseY * this.scaleRatio);
            } else if (e.getWheelRotation() == -1) {
                this.setScale(this.scaleRatio / 2.0);
                positionX -= (int)((double)relativeMouseX * this.scaleRatio);
                positionY -= (int)((double)relativeMouseY * this.scaleRatio);
            }
            if (positionX < 0) {
                positionX = 0;
            }
            if (positionY < 0) {
                positionY = 0;
            }
            this.scrollPane.getHorizontalScrollBar().setValue((int)((double)positionX / this.scaleRatio));
            this.scrollPane.getVerticalScrollBar().setValue((int)((double)positionY / this.scaleRatio));
            this.repaint();
        });
    }

    private void imageAreaMouseDragged(MouseEvent evt) {
        if (null != this.toolMode) {
            switch (this.toolMode) {
                case DOTTER: {
                    int x = (int)((double)evt.getX() * this.scaleRatio);
                    int y = (int)((double)evt.getY() * this.scaleRatio);
                    if (this.graphics != null) {
                        this.graphics.fillOval(x - 5, y - 5, 10, 10);
                        this.imageArea.repaint();
                    } else {
                        System.out.println("Graphics is null!");
                    }
                    evt.consume();
                    break;
                }
                case PENCIL: {
                    break;
                }
                case LINE: {
                    break;
                }
            }
        }
    }

    private void imageAreaMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && null != this.toolMode) {
            switch (this.toolMode) {
                case DOTTER: {
                    int x = (int)((double)evt.getX() * this.scaleRatio);
                    int y = (int)((double)evt.getY() * this.scaleRatio);
                    if (this.graphics != null) {
                        this.graphics.fillOval(x - 5, y - 5, 10, 10);
                        this.repaint();
                    } else {
                        System.out.println("Graphics is null!");
                    }
                    evt.consume();
                    break;
                }
                case PENCIL: {
                    break;
                }
                case LINE: {
                    break;
                }
            }
        }
    }

    public void performCopy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performCut() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performDelete() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performPaste() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performSelectAll() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void printFile() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job.printDialog()) {
            try {
                job.setPrintable((graphics1, pageFormat, pageIndex) -> {
                    this.imageArea.print(graphics1);
                    if (pageIndex == 0) {
                        return 0;
                    }
                    return 1;
                });
                job.print();
            }
            catch (PrinterException ex) {
                Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
        if (this.highlight != null) {
            // empty if block
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.setAutoscrolls(true);
        this.setInheritsPopupMenu(true);
        this.setName("Form");
        this.setLayout(new BoxLayout(this, 2));
        this.scrollPane.setName("scrollPane");
        this.add(this.scrollPane);
    }

    public boolean isModified() {
        return false;
    }

    public void setModified(boolean modified) {
    }

    public boolean isEditEnabled() {
        return false;
    }

    public boolean isPasteEnabled() {
        return false;
    }

    public UndoManager getUndo() {
        return this.undo;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.imageArea.setComponentPopupMenu(menu);
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setScale(double ratio) {
        this.scaleRatio = ratio;
        this.imageArea.updateSize();
        this.scrollPane.repaint();
    }

    public double getScale() {
        return this.scaleRatio;
    }

    @Nullable
    public static BufferedImage toBufferedImage(@Nullable Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImagePanel.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width == -1 || height == -1) {
                // empty if block
            }
            bimage = gc.createCompatibleImage(width, height, transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.hasAlpha();
    }

    @Override
    public Point getMousePosition() {
        return this.imageArea.getMousePosition();
    }

    public void attachCaretListener(MouseMotionListener listener) {
        this.imageArea.addMouseMotionListener(listener);
    }

    public Color getToolColor() {
        return this.toolColor;
    }

    public void setToolColor(Color toolColor) {
        this.toolColor = toolColor;
        if (this.graphics != null) {
            this.graphics.setColor(toolColor);
        }
    }

    public void performResize(int width, int height) {
        this.image = ImagePanel.toBufferedImage(this.image.getScaledInstance(width, height, 1));
        this.graphics = this.image.getGraphics();
        this.graphics.setColor(this.toolColor);
        this.setScale(this.scaleRatio);
    }

    public void newImage() {
        this.image = ImagePanel.toBufferedImage(this.createImage(100, 100));
        this.graphics = this.image.getGraphics();
        this.graphics.setColor(Color.WHITE);
        this.graphics.fillRect(0, 0, 100, 100);
        this.graphics.setColor(this.toolColor);
    }

    @Nullable
    public Image getImage() {
        return this.image;
    }

    public void initImage() {
        this.image = this.createImage(1, 1);
    }

    public void setImage(Image image) {
        this.image = image;
        this.graphics = image.getGraphics();
        this.graphics.setColor(this.toolColor);
        this.setScale(this.scaleRatio);
    }

    public boolean isSelection() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean canSelectAll() {
        return false;
    }

    public boolean canPaste() {
        return false;
    }

    public boolean canDelete() {
        return false;
    }

    public void setUpdateListener(ClipboardActionsUpdateListener updateListener) {
    }

    public void registerImageStatus(ImageStatusPanel imageStatusPanel) {
        this.imageStatusPanel = imageStatusPanel;
    }

    public Point getImageSize() {
        return new Point(this.image.getWidth(null), this.image.getHeight(null));
    }

    private class ImageAreaPanel
    extends JPanel {
        private int width;
        private int height;
        private int scaledWidth;
        private int scaledHeight;
        private final ImageObserver imageObserver = (img, infoflags, x1, y1, width1, height1) -> true;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle clipBounds = g.getClipBounds();
            g.setColor(Color.WHITE);
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.x + clipBounds.width, clipBounds.y + clipBounds.height);
            g.drawImage(ImagePanel.this.image, 0, 0, this.scaledWidth, this.scaledHeight, 0, 0, this.width, this.height, this.imageObserver);
        }

        public void updateSize() {
            this.width = ImagePanel.this.image.getWidth(this.imageObserver);
            this.height = ImagePanel.this.image.getHeight(this.imageObserver);
            this.scaledWidth = (int)Math.ceil((double)this.width / ImagePanel.this.scaleRatio);
            if (this.scaledWidth < 1) {
                this.scaledWidth = 1;
            }
            this.scaledHeight = (int)Math.ceil((double)this.height / ImagePanel.this.scaleRatio);
            if (this.scaledHeight < 1) {
                this.scaledHeight = 1;
            }
            this.setPreferredSize(new Dimension(this.scaledWidth, this.scaledHeight));
            this.revalidate();
        }
    }

    public static enum ToolMode {
        DOTTER,
        PENCIL,
        LINE;

    }
}

