/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture;

import java.awt.Toolkit;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import org.exbin.framework.editor.picture.ImageEditor;
import org.exbin.framework.editor.picture.PictureFileType;
import org.exbin.framework.editor.picture.gui.ImagePanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileType;
import org.exbin.xbup.core.block.declaration.XBDeclaration;
import org.exbin.xbup.core.block.declaration.XBFormatDecl;
import org.exbin.xbup.core.block.declaration.local.XBLFormatDecl;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.XBPCatalog;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.convert.XBTTypeUndeclaringFilter;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventListenerToListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTListenerToEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullTypeDeclaringFilter;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.serial.XBPSerialReader;
import org.exbin.xbup.core.serial.XBPSerialWriter;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.visual.picture.XBBufferedImage;

@ParametersAreNonnullByDefault
public class ImageFileHandler
implements FileHandler {
    private static final String DEFAULT_PICTURE_FILE_EXT = "PNG";
    private ImagePanel imagePanel = new ImagePanel();
    private URI fileUri = null;
    private String ext = null;
    private String title;
    private FileType fileType = null;

    public int getId() {
        return -1;
    }

    @Nonnull
    public ImagePanel getComponent() {
        return this.imagePanel;
    }

    public void loadFromFile(URI fileUri, @Nullable FileType fileType) {
        File file = new File(fileUri);
        if ("XBPictureEditor.XBPFileType".equals(fileType.getFileTypeId())) {
            try {
                if (this.imagePanel.getImage() == null) {
                    this.imagePanel.initImage();
                }
                XBPCatalog catalog = new XBPCatalog();
                catalog.addFormatDecl(this.getContextFormatDecl());
                XBLFormatDecl formatDecl = new XBLFormatDecl(XBBufferedImage.XBUP_FORMATREV_CATALOGPATH);
                XBBufferedImage bufferedImage = new XBBufferedImage(ImagePanel.toBufferedImage(this.imagePanel.getImage()));
                XBDeclaration declaration = new XBDeclaration((XBFormatDecl)formatDecl, (XBSerializable)bufferedImage);
                XBTPullTypeDeclaringFilter typeProcessing = new XBTPullTypeDeclaringFilter((XBCatalog)catalog);
                typeProcessing.attachXBTPullProvider((XBTPullProvider)new XBToXBTPullConvertor((XBPullProvider)new XBPullReader((InputStream)new FileInputStream(file))));
                XBPSerialReader reader = new XBPSerialReader((XBTPullProvider)typeProcessing);
                reader.read((XBSerializable)declaration);
                this.imagePanel.setImage(bufferedImage.getImage());
                this.fileUri = fileUri;
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(ImageFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                this.imagePanel.setImage(ImagePanel.toBufferedImage(Toolkit.getDefaultToolkit().getImage(fileUri.toURL())));
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(ImageFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void saveFile() {
        this.saveToFile(this.fileUri, this.fileType);
    }

    public void saveToFile(URI fileUri, @Nullable FileType fileType) {
        File file = new File(fileUri);
        if ("XBPictureEditor.XBPFileType".equals(fileType.getFileTypeId())) {
            try {
                FileOutputStream output = new FileOutputStream(file);
                XBPCatalog catalog = new XBPCatalog();
                catalog.addFormatDecl(this.getContextFormatDecl());
                XBLFormatDecl formatDecl = new XBLFormatDecl(XBBufferedImage.XBUP_FORMATREV_CATALOGPATH);
                XBDeclaration declaration = new XBDeclaration((XBFormatDecl)formatDecl, (XBSerializable)new XBBufferedImage(ImagePanel.toBufferedImage(this.imagePanel.getImage())));
                declaration.realignReservation((XBCatalog)catalog);
                XBTTypeUndeclaringFilter typeProcessing = new XBTTypeUndeclaringFilter((XBCatalog)catalog);
                typeProcessing.attachXBTListener((XBTListener)new XBTEventListenerToListener((XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter((OutputStream)output))));
                XBPSerialWriter writer = new XBPSerialWriter((XBTEventListener)new XBTListenerToEventListener((XBTListener)typeProcessing));
                writer.write((XBSerializable)declaration);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(ImageFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                if (fileType instanceof PictureFileType) {
                    this.ext = ((PictureFileType)fileType).getExt();
                }
                ImageIO.write((RenderedImage)((Object)this.imagePanel.getImage()), this.ext == null ? DEFAULT_PICTURE_FILE_EXT : this.ext, file);
            }
            catch (IOException ex) {
                Logger.getLogger(ImageFileHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Nonnull
    public Optional<URI> getFileUri() {
        return Optional.ofNullable(this.fileUri);
    }

    @Nonnull
    public String getTitle() {
        if (this.fileUri != null) {
            String path = this.fileUri.getPath();
            int lastSegment = path.lastIndexOf("/");
            String fileName = lastSegment < 0 ? path : path.substring(lastSegment + 1);
            return fileName == null ? "" : fileName;
        }
        return this.title == null ? "" : this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nonnull
    public Optional<FileType> getFileType() {
        return Optional.ofNullable(this.fileType);
    }

    public void clearFile() {
        this.imagePanel.newImage();
        this.imagePanel.setModified(false);
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public boolean isModified() {
        return this.imagePanel.isModified();
    }

    public XBLFormatDecl getContextFormatDecl() {
        XBPSerialReader reader = new XBPSerialReader(this.getClass().getResourceAsStream("/org/exbin/framework/editor/picture/resources/xbp_format_decl.xb"));
        XBLFormatDecl formatDecl = new XBLFormatDecl();
        try {
            reader.read((XBSerializable)formatDecl);
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(ImageEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        return formatDecl;
    }
}

