/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.NextToMode;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.api.XBModuleRepositoryUtils;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.picture.ImageControlApi;
import org.exbin.framework.editor.picture.ImageEditor;
import org.exbin.framework.editor.picture.PictureFileType;
import org.exbin.framework.editor.picture.action.PictureOperationActions;
import org.exbin.framework.editor.picture.action.PrintAction;
import org.exbin.framework.editor.picture.action.PropertiesAction;
import org.exbin.framework.editor.picture.action.ToolColorAction;
import org.exbin.framework.editor.picture.action.ZoomControlActions;
import org.exbin.framework.editor.picture.gui.ImagePanel;
import org.exbin.framework.editor.picture.gui.ImageStatusPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.file.api.FileModuleApi;
import org.exbin.framework.file.api.FileType;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.operation.undo.api.OperationUndoModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class EditorPictureModule
implements XBApplicationModule {
    public static final String MODULE_ID = XBModuleRepositoryUtils.getModuleIdByApi(EditorPictureModule.class);
    public static final String XBPFILETYPE = "XBPictureEditor.XBPFileType";
    public static final String ZOOM_MODE_SUBMENU_ID = MODULE_ID + ".zoomSubMenu";
    public static final String PICTURE_MENU_ID = MODULE_ID + ".pictureMenu";
    public static final String PICTURE_OPERATION_MENU_ID = MODULE_ID + ".pictureOperationMenu";
    public static final String PICTURE_POPUP_MENU_ID = MODULE_ID + ".picturePopupMenu";
    public static final String IMAGE_STATUS_BAR_ID = "imageStatusBar";
    private XBApplication application;
    private EditorProvider editorProvider;
    private ResourceBundle resourceBundle;
    private ImageStatusPanel imageStatusPanel;
    private ToolColorAction toolColorAction;
    private PropertiesAction propertiesAction;
    private PrintAction printAction;
    private ZoomControlActions zoomControlActions;
    private PictureOperationActions pictureOperationActions;

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void unregisterModule(String moduleId) {
    }

    private void ensureSetup() {
        if (this.editorProvider == null) {
            this.getEditorProvider();
        }
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    public EditorProvider getEditorProvider() {
        if (this.editorProvider == null) {
            ImageEditor imageEditor = new ImageEditor(this.application);
            OperationUndoModuleApi undoModule = (OperationUndoModuleApi)this.application.getModuleRepository().getModuleByInterface(OperationUndoModuleApi.class);
            this.editorProvider = imageEditor;
            imageEditor.setMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (EditorPictureModule.this.editorProvider == null) {
                        return;
                    }
                    EditorPictureModule.this.updateCurrentPosition();
                }
            });
            imageEditor.setPopupMenu(this.createPopupMenu());
        }
        return this.editorProvider;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(EditorPictureModule.class);
        }
        return this.resourceBundle;
    }

    public void registerFileTypes() {
        String[] formats;
        FileModuleApi fileModule = (FileModuleApi)this.application.getModuleRepository().getModuleByInterface(FileModuleApi.class);
        for (String ext : formats = ImageIO.getReaderFormatNames()) {
            if (!ext.toLowerCase().equals(ext)) continue;
            fileModule.addFileType((FileType)new PictureFileType(ext));
        }
        fileModule.addFileType((FileType)new XBPFileType());
    }

    private void updateCurrentPosition() {
        if (this.imageStatusPanel != null) {
            Optional activeFile = this.editorProvider.getActiveFile();
            if (!activeFile.isPresent()) {
                throw new IllegalStateException();
            }
            ImagePanel imagePanel = (ImagePanel)((FileHandler)activeFile.get()).getComponent();
            Point mousePosition = imagePanel.getMousePosition();
            double scale = imagePanel.getScale();
            if (mousePosition != null) {
                this.imageStatusPanel.setCurrentPosition(new Point((int)((double)mousePosition.x * scale), (int)((double)mousePosition.y * scale)));
            }
        }
    }

    public void registerStatusBar() {
        this.imageStatusPanel = new ImageStatusPanel(new ImageControlApi(){

            @Override
            public void editSelection() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        frameModule.registerStatusBar(MODULE_ID, IMAGE_STATUS_BAR_ID, (JPanel)this.imageStatusPanel);
        frameModule.switchStatusBar(IMAGE_STATUS_BAR_ID);
        Optional activeFile = this.editorProvider.getActiveFile();
        if (!activeFile.isPresent()) {
            return;
        }
        ImagePanel imagePanel = (ImagePanel)((FileHandler)activeFile.get()).getComponent();
        imagePanel.registerImageStatus(this.imageStatusPanel);
    }

    public void registerPropertiesMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getPropertiesAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    public void registerPrintMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.FILE_MENU_ID, MODULE_ID, (Action)this.getPrintAction(), new MenuPosition(PositionMode.BOTTOM));
    }

    @Nonnull
    private PictureOperationActions getPictureOperationActions() {
        if (this.pictureOperationActions == null) {
            this.ensureSetup();
            this.pictureOperationActions = new PictureOperationActions();
            this.pictureOperationActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.pictureOperationActions;
    }

    public void registerOptionsMenuPanels() {
    }

    public void registerOptionsPanels() {
    }

    @Nonnull
    private JPopupMenu createPopupMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(PICTURE_POPUP_MENU_ID, MODULE_ID);
        actionModule.registerClipboardMenuItems(PICTURE_POPUP_MENU_ID, MODULE_ID, SeparationMode.AROUND);
        JPopupMenu popupMenu = new JPopupMenu();
        actionModule.buildMenu(popupMenu, PICTURE_POPUP_MENU_ID);
        return popupMenu;
    }

    public void registerToolsOptionsMenuActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.TOOLS_MENU_ID, MODULE_ID, (Action)this.getToolColorAction(), new MenuPosition(PositionMode.TOP));
    }

    public void registerZoomModeMenu() {
        this.getZoomControlActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, ZOOM_MODE_SUBMENU_ID, "Zoom", new MenuPosition(PositionMode.BOTTOM));
        actionModule.registerMenu(ZOOM_MODE_SUBMENU_ID, MODULE_ID);
        actionModule.registerMenuItem(ZOOM_MODE_SUBMENU_ID, MODULE_ID, this.zoomControlActions.getZoomUpAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(ZOOM_MODE_SUBMENU_ID, MODULE_ID, this.zoomControlActions.getNormalZoomAction(), new MenuPosition(PositionMode.TOP));
        actionModule.registerMenuItem(ZOOM_MODE_SUBMENU_ID, MODULE_ID, this.zoomControlActions.getZoomDownAction(), new MenuPosition(PositionMode.TOP));
    }

    @Nonnull
    private PropertiesAction getPropertiesAction() {
        if (this.propertiesAction == null) {
            this.ensureSetup();
            this.propertiesAction = new PropertiesAction();
            this.propertiesAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.propertiesAction;
    }

    @Nonnull
    private ToolColorAction getToolColorAction() {
        if (this.toolColorAction == null) {
            this.ensureSetup();
            this.toolColorAction = new ToolColorAction();
            this.toolColorAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.toolColorAction;
    }

    @Nonnull
    private PrintAction getPrintAction() {
        if (this.printAction == null) {
            this.ensureSetup();
            this.printAction = new PrintAction();
            this.printAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.printAction;
    }

    @Nonnull
    private ZoomControlActions getZoomControlActions() {
        if (this.zoomControlActions == null) {
            this.ensureSetup();
            this.zoomControlActions = new ZoomControlActions();
            this.zoomControlActions.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.zoomControlActions;
    }

    public void registerPictureMenu() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenu(PICTURE_MENU_ID, MODULE_ID);
        actionModule.registerMenuItem(FrameModuleApi.MAIN_MENU_ID, MODULE_ID, PICTURE_MENU_ID, "Picture", new MenuPosition(NextToMode.AFTER, "View"));
    }

    public void registerPictureOperationMenu() {
        this.getPictureOperationActions();
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuItem(PICTURE_MENU_ID, MODULE_ID, this.pictureOperationActions.getRevertAction(), new MenuPosition(PositionMode.TOP));
    }

    @Nullable
    public static String getExtension(File file) {
        String ext = null;
        String str = file.getName();
        int i = str.lastIndexOf(46);
        if (i > 0 && i < str.length() - 1) {
            ext = str.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    @ParametersAreNonnullByDefault
    public class XBPFileType
    extends FileFilter
    implements FileType {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = EditorPictureModule.getExtension(f);
            if (extension != null) {
                if (extension.length() < 3) {
                    return false;
                }
                return "xbp".contains(extension.substring(0, 3));
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "XBUP Picture Files (*.xbp*)";
        }

        @Nonnull
        public String getFileTypeId() {
            return EditorPictureModule.XBPFILETYPE;
        }
    }
}

