/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.PositionCodeType;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.StatusCursorPositionFormat;
import org.exbin.framework.bined.StatusDocumentSizeFormat;
import org.exbin.framework.bined.options.StatusOptions;
import org.exbin.framework.bined.options.impl.StatusOptionsImpl;

@ParametersAreNonnullByDefault
public class StatusPreferences
implements StatusOptions {
    public static final String PREFERENCES_CURSOR_POSITION_CODE_TYPE = "statusCursorPositionFormat";
    public static final String PREFERENCES_CURSOR_POSITION_SHOW_OFFSET = "statusCursorShowOffset";
    public static final String PREFERENCES_DOCUMENT_SIZE_CODE_TYPE = "statusDocumentSizeFormat";
    public static final String PREFERENCES_DOCUMENT_SIZE_SHOW_RELATIVE = "statusDocumentShowRelative";
    public static final String PREFERENCES_OCTAL_SPACE_GROUP_SIZE = "statusOctalSpaceGroupSize";
    public static final String PREFERENCES_DECIMAL_SPACE_GROUP_SIZE = "statusDecimalSpaceGroupSize";
    public static final String PREFERENCES_HEXADECIMAL_SPACE_GROUP_SIZE = "statusHexadecimalSpaceGroupSize";
    private final Preferences preferences;

    public StatusPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public PositionCodeType getCursorPositionCodeType() {
        PositionCodeType defaultCodeType = PositionCodeType.DECIMAL;
        try {
            return PositionCodeType.valueOf((String)this.preferences.get(PREFERENCES_CURSOR_POSITION_CODE_TYPE, defaultCodeType.name()));
        }
        catch (Exception ex) {
            Logger.getLogger(StatusPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultCodeType;
        }
    }

    public void setCursorPositionCodeType(PositionCodeType statusCursorPositionCodeType) {
        this.preferences.put(PREFERENCES_CURSOR_POSITION_CODE_TYPE, statusCursorPositionCodeType.name());
    }

    public boolean isCursorShowOffset() {
        return this.preferences.getBoolean(PREFERENCES_CURSOR_POSITION_SHOW_OFFSET, true);
    }

    public void setCursorShowOffset(boolean statusCursorShowOffset) {
        this.preferences.putBoolean(PREFERENCES_CURSOR_POSITION_SHOW_OFFSET, statusCursorShowOffset);
    }

    @Nonnull
    public PositionCodeType getDocumentSizeCodeType() {
        PositionCodeType defaultCodeType = PositionCodeType.DECIMAL;
        try {
            return PositionCodeType.valueOf((String)this.preferences.get(PREFERENCES_DOCUMENT_SIZE_CODE_TYPE, defaultCodeType.name()));
        }
        catch (Exception ex) {
            Logger.getLogger(StatusPreferences.class.getName()).log(Level.SEVERE, null, ex);
            return defaultCodeType;
        }
    }

    public void setDocumentSizeCodeType(PositionCodeType statusDocumentSizeCodeType) {
        this.preferences.put(PREFERENCES_DOCUMENT_SIZE_CODE_TYPE, statusDocumentSizeCodeType.name());
    }

    public boolean isDocumentSizeShowRelative() {
        return this.preferences.getBoolean(PREFERENCES_DOCUMENT_SIZE_SHOW_RELATIVE, true);
    }

    public void setDocumentSizeShowRelative(boolean statusDocumentSizeShowRelative) {
        this.preferences.putBoolean(PREFERENCES_DOCUMENT_SIZE_SHOW_RELATIVE, statusDocumentSizeShowRelative);
    }

    @Override
    @Nonnull
    public StatusCursorPositionFormat getCursorPositionFormat() {
        return new StatusCursorPositionFormat(this.getCursorPositionCodeType(), this.isCursorShowOffset());
    }

    @Override
    @Nonnull
    public StatusDocumentSizeFormat getDocumentSizeFormat() {
        return new StatusDocumentSizeFormat(this.getDocumentSizeCodeType(), this.isDocumentSizeShowRelative());
    }

    @Override
    public void setCursorPositionFormat(StatusCursorPositionFormat cursorPositionFormat) {
        this.setCursorPositionCodeType(cursorPositionFormat.getCodeType());
        this.setCursorShowOffset(cursorPositionFormat.isShowOffset());
    }

    @Override
    public void setDocumentSizeFormat(StatusDocumentSizeFormat documentSizeFormat) {
        this.setDocumentSizeCodeType(documentSizeFormat.getCodeType());
        this.setDocumentSizeShowRelative(documentSizeFormat.isShowRelative());
    }

    @Override
    public int getOctalSpaceGroupSize() {
        return this.preferences.getInt(PREFERENCES_OCTAL_SPACE_GROUP_SIZE, StatusOptionsImpl.DEFAULT_OCTAL_SPACE_GROUP_SIZE);
    }

    @Override
    public void setOctalSpaceGroupSize(int octalSpaceSize) {
        this.preferences.putInt(PREFERENCES_OCTAL_SPACE_GROUP_SIZE, octalSpaceSize);
    }

    @Override
    public int getDecimalSpaceGroupSize() {
        return this.preferences.getInt(PREFERENCES_DECIMAL_SPACE_GROUP_SIZE, StatusOptionsImpl.DEFAULT_DECIMAL_SPACE_GROUP_SIZE);
    }

    @Override
    public void setDecimalSpaceGroupSize(int decimalSpaceSize) {
        this.preferences.putInt(PREFERENCES_DECIMAL_SPACE_GROUP_SIZE, decimalSpaceSize);
    }

    @Override
    public int getHexadecimalSpaceGroupSize() {
        return this.preferences.getInt(PREFERENCES_HEXADECIMAL_SPACE_GROUP_SIZE, StatusOptionsImpl.DEFAULT_HEXADECIMAL_SPACE_GROUP_SIZE);
    }

    @Override
    public void setHexadecimalSpaceGroupSize(int hexadecimalSpaceSize) {
        this.preferences.putInt(PREFERENCES_HEXADECIMAL_SPACE_GROUP_SIZE, hexadecimalSpaceSize);
    }
}

