/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.swing.extended.layout.DefaultExtendedCodeAreaLayoutProfile;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.options.CodeAreaLayoutOptions;

@ParametersAreNonnullByDefault
public class CodeAreaLayoutPreferences
implements CodeAreaLayoutOptions {
    public static final String PREFERENCES_LAYOUT_PROFILES_COUNT = "layoutProfilesCount";
    public static final String PREFERENCES_LAYOUT_PROFILE_SELECTED = "layoutProfileSelected";
    public static final String PREFERENCES_LAYOUT_PROFILE_NAME_PREFIX = "layoutProfileName.";
    public static final String PREFERENCES_LAYOUT_VALUE_PREFIX = "layouts.";
    public static final String LAYOUT_SHOW_HEADER = "showHeader";
    public static final String LAYOUT_SHOW_ROW_POSITION = "showRowPosition";
    public static final String LAYOUT_TOP_HEADER_SPACE = "topHeaderSpace";
    public static final String LAYOUT_BOTTOM_HEADER_SPACE = "bottomHeaderSpace";
    public static final String LAYOUT_LEFT_ROW_POSITION_SPACE = "leftRowPositionSpace";
    public static final String LAYOUT_RIGHT_ROW_POSITION_SPACE = "rightRowPositionSpace";
    public static final String LAYOUT_HALF_SPACE_GROUP_SIZE = "halfSpaceGroupSize";
    public static final String LAYOUT_SPACE_GROUP_SIZE = "spaceGroupSize";
    public static final String LAYOUT_DOUBLE_SPACE_GROUP_SIZE = "doubleSpaceGroupSize";
    private final Preferences preferences;

    public CodeAreaLayoutPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Nonnull
    public List<String> getLayoutProfilesList() {
        ArrayList<String> profilesList = new ArrayList<String>();
        int profilesCount = this.preferences.getInt(PREFERENCES_LAYOUT_PROFILES_COUNT, 0);
        for (int i = 0; i < profilesCount; ++i) {
            String profileName = this.preferences.get(PREFERENCES_LAYOUT_PROFILE_NAME_PREFIX + String.valueOf(i), "");
            profilesList.add(profileName);
        }
        return profilesList;
    }

    public void setLayoutProfilesList(List<String> layoutNames) {
        int themesCount = layoutNames.size();
        this.preferences.putInt(PREFERENCES_LAYOUT_PROFILES_COUNT, themesCount);
        for (int i = 0; i < themesCount; ++i) {
            this.preferences.put(PREFERENCES_LAYOUT_PROFILE_NAME_PREFIX + String.valueOf(i), layoutNames.get(i));
        }
    }

    @Override
    public int getSelectedProfile() {
        return this.preferences.getInt(PREFERENCES_LAYOUT_PROFILE_SELECTED, -1);
    }

    @Override
    public void setSelectedProfile(int profileIndex) {
        this.preferences.putInt(PREFERENCES_LAYOUT_PROFILE_SELECTED, profileIndex);
    }

    @Override
    @Nonnull
    public DefaultExtendedCodeAreaLayoutProfile getLayoutProfile(int profileIndex) {
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = new DefaultExtendedCodeAreaLayoutProfile();
        String layoutPrefix = PREFERENCES_LAYOUT_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        layoutProfile.setShowHeader(this.preferences.getBoolean(layoutPrefix + LAYOUT_SHOW_HEADER, layoutProfile.isShowHeader()));
        layoutProfile.setShowRowPosition(this.preferences.getBoolean(layoutPrefix + LAYOUT_SHOW_ROW_POSITION, layoutProfile.isShowRowPosition()));
        layoutProfile.setTopHeaderSpace(this.preferences.getInt(layoutPrefix + LAYOUT_TOP_HEADER_SPACE, layoutProfile.getTopHeaderSpace()));
        layoutProfile.setBottomHeaderSpace(this.preferences.getInt(layoutPrefix + LAYOUT_BOTTOM_HEADER_SPACE, layoutProfile.getBottomHeaderSpace()));
        layoutProfile.setLeftRowPositionSpace(this.preferences.getInt(layoutPrefix + LAYOUT_LEFT_ROW_POSITION_SPACE, layoutProfile.getLeftRowPositionSpace()));
        layoutProfile.setRightRowPositionSpace(this.preferences.getInt(layoutPrefix + LAYOUT_RIGHT_ROW_POSITION_SPACE, layoutProfile.getRightRowPositionSpace()));
        layoutProfile.setHalfSpaceGroupSize(this.preferences.getInt(layoutPrefix + LAYOUT_HALF_SPACE_GROUP_SIZE, layoutProfile.getHalfSpaceGroupSize()));
        layoutProfile.setSpaceGroupSize(this.preferences.getInt(layoutPrefix + LAYOUT_SPACE_GROUP_SIZE, layoutProfile.getSpaceGroupSize()));
        layoutProfile.setDoubleSpaceGroupSize(this.preferences.getInt(layoutPrefix + LAYOUT_DOUBLE_SPACE_GROUP_SIZE, layoutProfile.getDoubleSpaceGroupSize()));
        return layoutProfile;
    }

    @Override
    public void setLayoutProfile(int profileIndex, DefaultExtendedCodeAreaLayoutProfile layoutProfile) {
        String layoutPrefix = PREFERENCES_LAYOUT_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        this.preferences.putBoolean(layoutPrefix + LAYOUT_SHOW_HEADER, layoutProfile.isShowHeader());
        this.preferences.putBoolean(layoutPrefix + LAYOUT_SHOW_ROW_POSITION, layoutProfile.isShowRowPosition());
        this.preferences.putInt(layoutPrefix + LAYOUT_TOP_HEADER_SPACE, layoutProfile.getTopHeaderSpace());
        this.preferences.putInt(layoutPrefix + LAYOUT_BOTTOM_HEADER_SPACE, layoutProfile.getBottomHeaderSpace());
        this.preferences.putInt(layoutPrefix + LAYOUT_LEFT_ROW_POSITION_SPACE, layoutProfile.getLeftRowPositionSpace());
        this.preferences.putInt(layoutPrefix + LAYOUT_RIGHT_ROW_POSITION_SPACE, layoutProfile.getRightRowPositionSpace());
        this.preferences.putInt(layoutPrefix + LAYOUT_HALF_SPACE_GROUP_SIZE, layoutProfile.getHalfSpaceGroupSize());
        this.preferences.putInt(layoutPrefix + LAYOUT_SPACE_GROUP_SIZE, layoutProfile.getSpaceGroupSize());
        this.preferences.putInt(layoutPrefix + LAYOUT_DOUBLE_SPACE_GROUP_SIZE, layoutProfile.getDoubleSpaceGroupSize());
    }

    @Override
    public void removeLayoutProfile(int profileIndex) {
        String layoutPrefix = PREFERENCES_LAYOUT_VALUE_PREFIX + String.valueOf(profileIndex) + ".";
        this.preferences.remove(layoutPrefix + LAYOUT_SHOW_HEADER);
        this.preferences.remove(layoutPrefix + LAYOUT_SHOW_ROW_POSITION);
        this.preferences.remove(layoutPrefix + LAYOUT_TOP_HEADER_SPACE);
        this.preferences.remove(layoutPrefix + LAYOUT_BOTTOM_HEADER_SPACE);
        this.preferences.remove(layoutPrefix + LAYOUT_LEFT_ROW_POSITION_SPACE);
        this.preferences.remove(layoutPrefix + LAYOUT_RIGHT_ROW_POSITION_SPACE);
        this.preferences.remove(layoutPrefix + LAYOUT_HALF_SPACE_GROUP_SIZE);
        this.preferences.remove(layoutPrefix + LAYOUT_SPACE_GROUP_SIZE);
        this.preferences.remove(layoutPrefix + LAYOUT_DOUBLE_SPACE_GROUP_SIZE);
    }
}

