/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.preferences;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.extended.theme.CodeAreaDecorationType;
import org.exbin.bined.swing.extended.layout.DefaultExtendedCodeAreaLayoutProfile;
import org.exbin.bined.swing.extended.layout.ExtendedCodeAreaDecorations;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.bined.FileHandlingMode;
import org.exbin.framework.bined.preferences.CodeAreaColorPreferences;
import org.exbin.framework.bined.preferences.CodeAreaLayoutPreferences;
import org.exbin.framework.bined.preferences.CodeAreaPreferences;
import org.exbin.framework.bined.preferences.CodeAreaThemePreferences;
import org.exbin.framework.bined.preferences.EditorPreferences;
import org.exbin.framework.bined.preferences.LegacyPreferences;
import org.exbin.framework.bined.preferences.StatusPreferences;
import org.exbin.framework.editor.text.preferences.TextEncodingPreferences;
import org.exbin.framework.editor.text.preferences.TextFontPreferences;

@ParametersAreNonnullByDefault
public class BinaryEditorPreferences {
    private static final String PREFERENCES_VERSION = "version";
    private static final String PREFERENCES_VERSION_VALUE = "0.2.1";
    private final Preferences preferences;
    private final EditorPreferences editorPreferences;
    private final StatusPreferences statusPreferences;
    private final CodeAreaPreferences codeAreaPreferences;
    private final TextEncodingPreferences encodingPreferences;
    private final TextFontPreferences fontPreferences;
    private final CodeAreaLayoutPreferences layoutPreferences;
    private final CodeAreaThemePreferences themePreferences;
    private final CodeAreaColorPreferences colorPreferences;

    public BinaryEditorPreferences(Preferences preferences) {
        this.preferences = preferences;
        this.editorPreferences = new EditorPreferences(preferences);
        this.statusPreferences = new StatusPreferences(preferences);
        this.codeAreaPreferences = new CodeAreaPreferences(preferences);
        this.encodingPreferences = new TextEncodingPreferences(preferences);
        this.fontPreferences = new TextFontPreferences(preferences);
        this.layoutPreferences = new CodeAreaLayoutPreferences(preferences);
        this.themePreferences = new CodeAreaThemePreferences(preferences);
        this.colorPreferences = new CodeAreaColorPreferences(preferences);
        this.convertOlderPreferences();
    }

    private void convertOlderPreferences() {
        String legacyDef = "LEGACY";
        String storedVersion = this.preferences.get(PREFERENCES_VERSION, "LEGACY");
        if (PREFERENCES_VERSION_VALUE.equals(storedVersion)) {
            return;
        }
        if ("LEGACY".equals(storedVersion)) {
            try {
                this.importLegacyPreferences();
            }
            finally {
                this.preferences.put(PREFERENCES_VERSION, PREFERENCES_VERSION_VALUE);
                this.preferences.flush();
            }
        }
        if ("0.2.0".equals(storedVersion)) {
            this.convertPreferences_0_2_0();
        }
    }

    @Nonnull
    public Preferences getPreferences() {
        return this.preferences;
    }

    @Nonnull
    public EditorPreferences getEditorPreferences() {
        return this.editorPreferences;
    }

    @Nonnull
    public StatusPreferences getStatusPreferences() {
        return this.statusPreferences;
    }

    @Nonnull
    public CodeAreaPreferences getCodeAreaPreferences() {
        return this.codeAreaPreferences;
    }

    @Nonnull
    public TextEncodingPreferences getEncodingPreferences() {
        return this.encodingPreferences;
    }

    @Nonnull
    public TextFontPreferences getFontPreferences() {
        return this.fontPreferences;
    }

    @Nonnull
    public CodeAreaLayoutPreferences getLayoutPreferences() {
        return this.layoutPreferences;
    }

    @Nonnull
    public CodeAreaThemePreferences getThemePreferences() {
        return this.themePreferences;
    }

    @Nonnull
    public CodeAreaColorPreferences getColorPreferences() {
        return this.colorPreferences;
    }

    private void importLegacyPreferences() {
        LegacyPreferences legacyPreferences = new LegacyPreferences(this.preferences);
        this.codeAreaPreferences.setCodeType(legacyPreferences.getCodeType());
        this.codeAreaPreferences.setRowWrappingMode(legacyPreferences.isLineWrapping() ? RowWrappingMode.WRAPPING : RowWrappingMode.NO_WRAPPING);
        this.codeAreaPreferences.setShowUnprintables(legacyPreferences.isShowNonprintables());
        this.codeAreaPreferences.setCodeCharactersCase(legacyPreferences.getCodeCharactersCase());
        this.codeAreaPreferences.setPositionCodeType(legacyPreferences.getPositionCodeType());
        this.codeAreaPreferences.setViewMode(legacyPreferences.getViewMode());
        this.codeAreaPreferences.setPaintRowPosBackground(legacyPreferences.isPaintRowPosBackground());
        this.codeAreaPreferences.setCodeColorization(legacyPreferences.isCodeColorization());
        this.editorPreferences.setFileHandlingMode(legacyPreferences.isDeltaMemoryMode() ? FileHandlingMode.DELTA : FileHandlingMode.MEMORY);
        ArrayList<String> layoutProfiles = new ArrayList<String>();
        layoutProfiles.add("Imported profile");
        DefaultExtendedCodeAreaLayoutProfile layoutProfile = new DefaultExtendedCodeAreaLayoutProfile();
        layoutProfile.setShowHeader(legacyPreferences.isShowHeader());
        layoutProfile.setShowRowPosition(legacyPreferences.isShowLineNumbers());
        layoutProfile.setSpaceGroupSize(legacyPreferences.getByteGroupSize());
        layoutProfile.setDoubleSpaceGroupSize(legacyPreferences.getSpaceGroupSize());
        this.layoutPreferences.setLayoutProfile(0, layoutProfile);
        this.layoutPreferences.setLayoutProfilesList(layoutProfiles);
        ArrayList<String> themeProfiles = new ArrayList<String>();
        themeProfiles.add("Imported profile");
        ExtendedCodeAreaThemeProfile themeProfile = new ExtendedCodeAreaThemeProfile();
        themeProfile.setBackgroundPaintMode(legacyPreferences.getBackgroundPaintMode());
        themeProfile.setPaintRowPosBackground(legacyPreferences.isPaintRowPosBackground());
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.HEADER_LINE, legacyPreferences.isDecorationHeaderLine());
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.ROW_POSITION_LINE, legacyPreferences.isDecorationLineNumLine());
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.SPLIT_LINE, legacyPreferences.isDecorationPreviewLine());
        themeProfile.setDecoration((CodeAreaDecorationType)ExtendedCodeAreaDecorations.BOX_LINES, legacyPreferences.isDecorationBox());
        this.themePreferences.setThemeProfile(0, themeProfile);
        this.themePreferences.setThemeProfilesList(themeProfiles);
        this.encodingPreferences.setSelectedEncoding(legacyPreferences.getSelectedEncoding());
        this.encodingPreferences.setEncodings(new ArrayList<String>(legacyPreferences.getEncodings()));
        Collection<String> legacyEncodings = legacyPreferences.getEncodings();
        ArrayList<String> encodings = new ArrayList<String>(legacyEncodings);
        if (!encodings.isEmpty() && !encodings.contains("UTF-8")) {
            encodings.add("UTF-8");
        }
        this.encodingPreferences.setEncodings(encodings);
        this.fontPreferences.setUseDefaultFont(legacyPreferences.isUseDefaultFont());
        this.fontPreferences.setFont(legacyPreferences.getCodeFont(CodeAreaPreferences.DEFAULT_FONT));
        this.preferences.flush();
    }

    private void convertPreferences_0_2_0() {
        String codeType = this.preferences.get("viewMode", "DUAL");
        if ("HEXADECIMAL".equals(codeType)) {
            this.codeAreaPreferences.setViewMode(CodeAreaViewMode.CODE_MATRIX);
        } else if ("PREVIEW".equals(codeType)) {
            this.codeAreaPreferences.setViewMode(CodeAreaViewMode.TEXT_PREVIEW);
        }
        this.preferences.flush();
    }
}

