/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.impl;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.highlight.swing.extended.ExtendedHighlightNonAsciiCodeAreaPainter;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.bined.options.CodeAreaOptions;
import org.exbin.framework.bined.preferences.CodeAreaPreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class CodeAreaOptionsImpl
implements OptionsData,
CodeAreaOptions {
    private CodeType codeType = CodeType.HEXADECIMAL;
    private boolean showUnprintables = true;
    private CodeCharactersCase codeCharactersCase = CodeCharactersCase.UPPER;
    private PositionCodeType positionCodeType = PositionCodeType.HEXADECIMAL;
    private CodeAreaViewMode viewMode = CodeAreaViewMode.DUAL;
    private boolean codeColorization = true;
    private RowWrappingMode rowWrappingMode;
    private int maxBytesPerRow;
    private int minRowPositionLength;
    private int maxRowPositionLength;

    @Override
    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Override
    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
    }

    @Override
    public boolean isShowUnprintables() {
        return this.showUnprintables;
    }

    @Override
    public void setShowUnprintables(boolean showUnprintables) {
        this.showUnprintables = showUnprintables;
    }

    @Override
    @Nonnull
    public CodeCharactersCase getCodeCharactersCase() {
        return this.codeCharactersCase;
    }

    @Override
    public void setCodeCharactersCase(CodeCharactersCase codeCharactersCase) {
        this.codeCharactersCase = codeCharactersCase;
    }

    @Override
    @Nonnull
    public PositionCodeType getPositionCodeType() {
        return this.positionCodeType;
    }

    @Override
    public void setPositionCodeType(PositionCodeType positionCodeType) {
        this.positionCodeType = positionCodeType;
    }

    @Override
    @Nonnull
    public CodeAreaViewMode getViewMode() {
        return this.viewMode;
    }

    @Override
    public void setViewMode(CodeAreaViewMode viewMode) {
        this.viewMode = viewMode;
    }

    @Override
    public boolean isCodeColorization() {
        return this.codeColorization;
    }

    @Override
    public void setCodeColorization(boolean codeColorization) {
        this.codeColorization = codeColorization;
    }

    @Override
    @Nonnull
    public RowWrappingMode getRowWrappingMode() {
        return this.rowWrappingMode;
    }

    @Override
    public void setRowWrappingMode(RowWrappingMode rowWrappingMode) {
        this.rowWrappingMode = rowWrappingMode;
    }

    @Override
    public int getMaxBytesPerRow() {
        return this.maxBytesPerRow;
    }

    @Override
    public void setMaxBytesPerRow(int maxBytesPerRow) {
        this.maxBytesPerRow = maxBytesPerRow;
    }

    @Override
    public int getMinRowPositionLength() {
        return this.minRowPositionLength;
    }

    @Override
    public void setMinRowPositionLength(int minRowPositionLength) {
        this.minRowPositionLength = minRowPositionLength;
    }

    @Override
    public int getMaxRowPositionLength() {
        return this.maxRowPositionLength;
    }

    @Override
    public void setMaxRowPositionLength(int maxRowPositionLength) {
        this.maxRowPositionLength = maxRowPositionLength;
    }

    public void loadFromPreferences(CodeAreaPreferences preferences) {
        this.codeType = preferences.getCodeType();
        this.showUnprintables = preferences.isShowUnprintables();
        this.codeCharactersCase = preferences.getCodeCharactersCase();
        this.positionCodeType = preferences.getPositionCodeType();
        this.viewMode = preferences.getViewMode();
        this.codeColorization = preferences.isCodeColorization();
        this.rowWrappingMode = preferences.getRowWrappingMode();
        this.maxBytesPerRow = preferences.getMaxBytesPerRow();
        this.minRowPositionLength = preferences.getMinRowPositionLength();
        this.maxRowPositionLength = preferences.getMaxRowPositionLength();
    }

    public void saveToPreferences(CodeAreaPreferences preferences) {
        preferences.setCodeType(this.codeType);
        preferences.setShowUnprintables(this.showUnprintables);
        preferences.setCodeCharactersCase(this.codeCharactersCase);
        preferences.setPositionCodeType(this.positionCodeType);
        preferences.setViewMode(this.viewMode);
        preferences.setCodeColorization(this.codeColorization);
        preferences.setRowWrappingMode(this.rowWrappingMode);
        preferences.setMaxBytesPerRow(this.maxBytesPerRow);
        preferences.setMinRowPositionLength(this.minRowPositionLength);
        preferences.setMaxRowPositionLength(this.maxRowPositionLength);
    }

    public static void applyFromCodeArea(CodeAreaOptions codeAreaOptions, ExtCodeArea codeArea) {
        codeAreaOptions.setCodeType(codeArea.getCodeType());
        codeAreaOptions.setShowUnprintables(codeArea.isShowUnprintables());
        codeAreaOptions.setCodeCharactersCase(codeArea.getCodeCharactersCase());
        codeAreaOptions.setPositionCodeType(codeArea.getPositionCodeType());
        codeAreaOptions.setViewMode(codeArea.getViewMode());
        CodeAreaPainter painter = codeArea.getPainter();
        if (painter instanceof ExtendedHighlightNonAsciiCodeAreaPainter) {
            codeAreaOptions.setCodeColorization(((ExtendedHighlightNonAsciiCodeAreaPainter)painter).isNonAsciiHighlightingEnabled());
        }
        codeAreaOptions.setRowWrappingMode(codeArea.getRowWrapping());
        codeAreaOptions.setMaxBytesPerRow(codeArea.getMaxBytesPerRow());
        codeAreaOptions.setMinRowPositionLength(codeArea.getMinRowPositionLength());
        codeAreaOptions.setMaxRowPositionLength(codeArea.getMaxRowPositionLength());
    }

    public static void applyToCodeArea(CodeAreaOptions codeAreaOptions, ExtCodeArea codeArea) {
        codeArea.setCodeType(codeAreaOptions.getCodeType());
        codeArea.setShowUnprintables(codeAreaOptions.isShowUnprintables());
        codeArea.setCodeCharactersCase(codeAreaOptions.getCodeCharactersCase());
        codeArea.setPositionCodeType(codeAreaOptions.getPositionCodeType());
        codeArea.setViewMode(codeAreaOptions.getViewMode());
        CodeAreaPainter painter = codeArea.getPainter();
        if (painter instanceof ExtendedHighlightNonAsciiCodeAreaPainter) {
            ((ExtendedHighlightNonAsciiCodeAreaPainter)painter).setNonAsciiHighlightingEnabled(codeAreaOptions.isCodeColorization());
        }
        codeArea.setRowWrapping(codeAreaOptions.getRowWrappingMode());
        codeArea.setMaxBytesPerRow(codeAreaOptions.getMaxBytesPerRow());
        codeArea.setMinRowPositionLength(codeAreaOptions.getMinRowPositionLength());
        codeArea.setMaxRowPositionLength(codeAreaOptions.getMaxRowPositionLength());
    }

    public void setOptions(CodeAreaOptionsImpl codeAreaOptions) {
        this.codeType = codeAreaOptions.codeType;
        this.showUnprintables = codeAreaOptions.showUnprintables;
        this.codeCharactersCase = codeAreaOptions.codeCharactersCase;
        this.positionCodeType = codeAreaOptions.positionCodeType;
        this.viewMode = codeAreaOptions.viewMode;
        this.codeColorization = codeAreaOptions.codeColorization;
        this.rowWrappingMode = codeAreaOptions.rowWrappingMode;
        this.maxBytesPerRow = codeAreaOptions.maxBytesPerRow;
        this.minRowPositionLength = codeAreaOptions.minRowPositionLength;
        this.maxRowPositionLength = codeAreaOptions.maxRowPositionLength;
    }
}

