/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.bined.options.gui.PreviewPanel;
import org.exbin.framework.bined.options.gui.ProfileListPanel;
import org.exbin.framework.bined.options.impl.CodeAreaThemeOptionsImpl;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ThemeProfilesPanel
extends JPanel
implements ProfileListPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ThemeProfilesPanel.class);
    private boolean modified = false;
    private AddProfileOperation addProfileOperation = null;
    private EditProfileOperation editProfileOperation = null;
    private CopyProfileOperation copyProfileOperation = null;
    private TemplateProfileOperation templateProfileOperation = null;
    private JButton addButton;
    private JButton copyButton;
    private JButton downButton;
    private JButton editButton;
    private JButton fromTemplateButton;
    private JButton hideButton;
    private PreviewPanel previewPanel;
    private JPanel profilesControlPanel;
    private JList<ThemeProfile> profilesList;
    private JScrollPane profilesListScrollPane;
    private JButton removeButton;
    private JButton selectAllButton;
    private JButton upButton;

    public ThemeProfilesPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.profilesList.setModel(new ProfilesListModel());
        this.profilesList.setCellRenderer(new ProfileCellRenderer());
        this.profilesList.addListSelectionListener(e -> this.updateStates());
    }

    public void setAddProfileOperation(AddProfileOperation addProfileOperation) {
        this.addProfileOperation = addProfileOperation;
    }

    public void setEditProfileOperation(EditProfileOperation editProfileOperation) {
        this.editProfileOperation = editProfileOperation;
    }

    public void setCopyProfileOperation(CopyProfileOperation copyProfileOperation) {
        this.copyProfileOperation = copyProfileOperation;
    }

    public void setTemplateProfileOperation(TemplateProfileOperation templateProfileOperation) {
        this.templateProfileOperation = templateProfileOperation;
    }

    private void updateStates() {
        int[] selectedIndices = this.profilesList.getSelectedIndices();
        boolean hasSelection = selectedIndices.length > 0;
        boolean singleSelection = selectedIndices.length == 1;
        boolean hasAnyItems = !this.getProfilesListModel().isEmpty();
        this.editButton.setEnabled(singleSelection);
        this.copyButton.setEnabled(singleSelection);
        this.selectAllButton.setEnabled(hasAnyItems);
        this.removeButton.setEnabled(hasSelection);
        if (hasSelection) {
            this.upButton.setEnabled(this.profilesList.getMaxSelectionIndex() >= selectedIndices.length);
            this.downButton.setEnabled(this.profilesList.getMinSelectionIndex() + selectedIndices.length < this.getProfilesListModel().getSize());
            if (selectedIndices.length == 1) {
                this.previewPanel.getCodeArea().setThemeProfile(this.getProfilesListModel().getElementAt(selectedIndices[0]).getThemeProfile());
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    @Override
    @Nonnull
    public List<String> getProfileNames() {
        ArrayList<String> profileNames = new ArrayList<String>();
        this.getProfilesListModel().profiles.forEach(profile -> profileNames.add(((ThemeProfile)profile).profileName));
        return profileNames;
    }

    @Nonnull
    private ProfilesListModel getProfilesListModel() {
        return (ProfilesListModel)this.profilesList.getModel();
    }

    @Override
    public void addProfileListPanelListener(ListDataListener listener) {
        this.getProfilesListModel().addListDataListener(listener);
    }

    public ExtendedCodeAreaThemeProfile getProfile(int profileIndex) {
        return this.getProfilesListModel().getElementAt(profileIndex).themeProfile;
    }

    private void initComponents() {
        this.profilesListScrollPane = new JScrollPane();
        this.profilesList = new JList();
        this.profilesControlPanel = new JPanel();
        this.addButton = new JButton();
        this.fromTemplateButton = new JButton();
        this.editButton = new JButton();
        this.copyButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.selectAllButton = new JButton();
        this.removeButton = new JButton();
        this.hideButton = new JButton();
        this.previewPanel = new PreviewPanel();
        this.profilesListScrollPane.setViewportView(this.profilesList);
        this.addButton.setText(this.resourceBundle.getString("addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.fromTemplateButton.setText(this.resourceBundle.getString("fromTemplateButton.text"));
        this.fromTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.fromTemplateButtonActionPerformed(evt);
            }
        });
        this.editButton.setText(this.resourceBundle.getString("editButton.text"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.editButtonActionPerformed(evt);
            }
        });
        this.copyButton.setText(this.resourceBundle.getString("copyButton.text"));
        this.copyButton.setEnabled(false);
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.copyButtonActionPerformed(evt);
            }
        });
        this.upButton.setText(this.resourceBundle.getString("upButton.text"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.upButtonActionPerformed(evt);
            }
        });
        this.downButton.setText(this.resourceBundle.getString("downButton.text"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.downButtonActionPerformed(evt);
            }
        });
        this.selectAllButton.setText(this.resourceBundle.getString("selectAllButton.text"));
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.selectAllButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(this.resourceBundle.getString("removeButton.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.hideButton.setText(this.resourceBundle.getString("hideButton.text"));
        this.hideButton.setEnabled(false);
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemeProfilesPanel.this.hideButtonActionPerformed(evt);
            }
        });
        GroupLayout profilesControlPanelLayout = new GroupLayout(this.profilesControlPanel);
        this.profilesControlPanel.setLayout(profilesControlPanelLayout);
        profilesControlPanelLayout.setHorizontalGroup(profilesControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(profilesControlPanelLayout.createSequentialGroup().addContainerGap().addGroup(profilesControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton, -1, 140, Short.MAX_VALUE).addComponent(this.editButton, -1, -1, Short.MAX_VALUE).addComponent(this.copyButton, -1, -1, Short.MAX_VALUE).addComponent(this.selectAllButton, GroupLayout.Alignment.TRAILING, -1, 140, Short.MAX_VALUE).addComponent(this.downButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.upButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.hideButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.fromTemplateButton, GroupLayout.Alignment.TRAILING, -1, 140, Short.MAX_VALUE)).addContainerGap()));
        profilesControlPanelLayout.setVerticalGroup(profilesControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(profilesControlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromTemplateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.profilesListScrollPane, -2, 0, Short.MAX_VALUE).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profilesControlPanel, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.profilesControlPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.profilesListScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        ProfilesListModel model = this.getProfilesListModel();
        int[] indices = this.profilesList.getSelectedIndices();
        int last = 0;
        for (int i = 0; i < indices.length; ++i) {
            int next = indices[i];
            if (last != next) {
                ThemeProfile item = model.getElementAt(next);
                model.add(next - 1, item);
                this.profilesList.getSelectionModel().addSelectionInterval(next - 1, next - 1);
                model.remove(next + 1);
                continue;
            }
            ++last;
        }
        this.wasModified();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        ProfilesListModel model = this.getProfilesListModel();
        int[] indices = this.profilesList.getSelectedIndices();
        int last = model.getSize() - 1;
        for (int i = indices.length; i > 0; --i) {
            int next = indices[i - 1];
            if (last != next) {
                ThemeProfile item = model.getElementAt(next);
                model.add(next + 2, item);
                this.profilesList.getSelectionModel().addSelectionInterval(next + 2, next + 2);
                model.remove(next);
                continue;
            }
            --last;
        }
        this.wasModified();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        ThemeProfile newProfileRecord;
        ProfilesListModel model = this.getProfilesListModel();
        int selectedIndex = this.profilesList.getSelectedIndex();
        if (this.addProfileOperation != null && (newProfileRecord = this.addProfileOperation.run(this, this.getNewProfileName())) != null) {
            if (selectedIndex >= 0) {
                this.profilesList.clearSelection();
                model.add(selectedIndex, newProfileRecord);
            } else {
                model.add(newProfileRecord);
            }
            this.wasModified();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        ProfilesListModel model = this.getProfilesListModel();
        model.removeIndices(this.profilesList.getSelectedIndices());
        this.profilesList.clearSelection();
        this.wasModified();
    }

    private void selectAllButtonActionPerformed(ActionEvent evt) {
        if (this.profilesList.getSelectedIndices().length < this.profilesList.getModel().getSize()) {
            this.profilesList.setSelectionInterval(0, this.profilesList.getModel().getSize() - 1);
        } else {
            this.profilesList.clearSelection();
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        ThemeProfile newProfileRecord;
        ProfilesListModel model = this.getProfilesListModel();
        int selectedIndex = this.profilesList.getSelectedIndex();
        ThemeProfile oldProfileRecord = model.getElementAt(selectedIndex);
        if (this.editProfileOperation != null && (newProfileRecord = this.editProfileOperation.run(this, oldProfileRecord)) != null) {
            ThemeProfile profileRecord = model.getElementAt(selectedIndex);
            profileRecord.profileName = newProfileRecord.getProfileName();
            profileRecord.themeProfile = newProfileRecord.themeProfile;
            model.notifyProfileModified(selectedIndex);
            this.wasModified();
        }
    }

    private void hideButtonActionPerformed(ActionEvent evt) {
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        ThemeProfile newProfileRecord;
        ProfilesListModel model = this.getProfilesListModel();
        int selectedIndex = this.profilesList.getSelectedIndex();
        ThemeProfile sourceProfile = model.getElementAt(selectedIndex);
        ThemeProfile profileRecord = new ThemeProfile(sourceProfile.profileName, sourceProfile.themeProfile);
        if (this.copyProfileOperation != null && (newProfileRecord = this.copyProfileOperation.run(this, profileRecord)) != null) {
            if (selectedIndex >= 0) {
                model.add(selectedIndex + 1, newProfileRecord);
                this.profilesList.setSelectedIndex(selectedIndex + 1);
            } else {
                this.profilesList.clearSelection();
                model.add(newProfileRecord);
            }
            this.wasModified();
        }
    }

    private void fromTemplateButtonActionPerformed(ActionEvent evt) {
        ThemeProfile newProfileRecord;
        ProfilesListModel model = this.getProfilesListModel();
        int selectedIndex = this.profilesList.getSelectedIndex();
        if (this.templateProfileOperation != null && (newProfileRecord = this.templateProfileOperation.run(this)) != null) {
            if (selectedIndex >= 0) {
                this.profilesList.clearSelection();
                model.add(selectedIndex, newProfileRecord);
            } else {
                model.add(newProfileRecord);
            }
            this.wasModified();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    private void wasModified() {
        this.modified = true;
    }

    public void addProfilesListListener(ListDataListener listener) {
        this.getProfilesListModel().addListDataListener(listener);
    }

    private boolean isValidProfileName(@Nullable String profileName) {
        return profileName != null && !"".equals(profileName.trim());
    }

    public void loadFromOptions(CodeAreaThemeOptionsImpl options) {
        ArrayList<ThemeProfile> profiles = new ArrayList<ThemeProfile>();
        List<String> profileNames = options.getProfileNames();
        for (int index = 0; index < profileNames.size(); ++index) {
            ThemeProfile profile = new ThemeProfile(profileNames.get(index), options.getThemeProfile(index));
            profiles.add(profile);
        }
        ProfilesListModel model = this.getProfilesListModel();
        model.setProfiles(profiles);
    }

    public void saveToOptions(CodeAreaThemeOptionsImpl options) {
        options.clearProfiles();
        ProfilesListModel model = this.getProfilesListModel();
        List<ThemeProfile> profiles = model.getProfiles();
        for (int index = 0; index < profiles.size(); ++index) {
            ThemeProfile profile = profiles.get(index);
            options.addProfile(profile.profileName, profile.themeProfile);
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ThemeProfilesPanel());
    }

    @Nonnull
    private String getNewProfileName() {
        String profileName = "Profile ";
        int profileIndex = 1;
        while (this.hasProfileWithName(profileName + profileIndex)) {
            ++profileIndex;
        }
        return profileName + profileIndex;
    }

    private boolean hasProfileWithName(String profileName) {
        return this.getProfilesListModel().getProfiles().stream().anyMatch(profile -> profileName.equals(((ThemeProfile)profile).profileName));
    }

    @ParametersAreNonnullByDefault
    public static interface TemplateProfileOperation {
        @Nullable
        public ThemeProfile run(JComponent var1);
    }

    @ParametersAreNonnullByDefault
    public static interface CopyProfileOperation {
        @Nullable
        public ThemeProfile run(JComponent var1, ThemeProfile var2);
    }

    @ParametersAreNonnullByDefault
    public static interface EditProfileOperation {
        @Nullable
        public ThemeProfile run(JComponent var1, ThemeProfile var2);
    }

    @ParametersAreNonnullByDefault
    public static interface AddProfileOperation {
        @Nullable
        public ThemeProfile run(JComponent var1, String var2);
    }

    @ParametersAreNonnullByDefault
    private static final class ProfileCellRenderer
    implements ListCellRenderer<ThemeProfile> {
        private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();

        private ProfileCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ThemeProfile> list, ThemeProfile value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, value.profileName, index, isSelected, cellHasFocus);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ProfilesListModel
    extends AbstractListModel<ThemeProfile> {
        private final List<ThemeProfile> profiles = new ArrayList<ThemeProfile>();

        @Override
        public int getSize() {
            if (this.profiles == null) {
                return 0;
            }
            return this.profiles.size();
        }

        public boolean isEmpty() {
            return this.profiles == null || this.profiles.isEmpty();
        }

        @Override
        @Nullable
        public ThemeProfile getElementAt(int index) {
            return this.profiles.get(index);
        }

        @Nonnull
        public List<ThemeProfile> getProfiles() {
            return this.profiles;
        }

        public void setProfiles(List<ThemeProfile> profiles) {
            int profilesSize;
            int size = this.profiles.size();
            if (size > 0) {
                this.profiles.clear();
                this.fireIntervalRemoved(this, 0, size - 1);
            }
            if ((profilesSize = profiles.size()) > 0) {
                this.profiles.addAll(profiles);
                this.fireIntervalAdded(this, 0, profilesSize - 1);
            }
        }

        public void addAll(List<ThemeProfile> list, int index) {
            if (index >= 0) {
                this.profiles.addAll(index, list);
                this.fireIntervalAdded(this, index, list.size() + index);
            } else {
                this.profiles.addAll(list);
                this.fireIntervalAdded(this, this.profiles.size() - list.size(), this.profiles.size());
            }
        }

        public void removeIndices(int[] indices) {
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.profiles.remove(indices[i]);
                this.fireIntervalRemoved(this, indices[i], indices[i]);
            }
        }

        public void remove(int index) {
            this.profiles.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        public void add(int index, ThemeProfile item) {
            this.profiles.add(index, item);
            this.fireIntervalAdded(this, index, index);
        }

        public void add(ThemeProfile item) {
            this.profiles.add(item);
            int index = this.profiles.size() - 1;
            this.fireIntervalAdded(this, index, index);
        }

        public void notifyProfileModified(int index) {
            this.fireContentsChanged(this, index, index);
        }
    }

    @ParametersAreNonnullByDefault
    public static final class ThemeProfile {
        private String profileName;
        private boolean visible = true;
        private ExtendedCodeAreaThemeProfile themeProfile;

        public ThemeProfile(String profileName, ExtendedCodeAreaThemeProfile themeProfile) {
            this.profileName = profileName;
            this.themeProfile = themeProfile;
        }

        @Nonnull
        public String getProfileName() {
            return this.profileName;
        }

        @Nonnull
        public ExtendedCodeAreaThemeProfile getThemeProfile() {
            return this.themeProfile;
        }
    }
}

