/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.bined.options.gui.ProfileSelectionPanel;
import org.exbin.framework.bined.options.gui.ThemeProfilesPanel;
import org.exbin.framework.bined.options.impl.CodeAreaThemeOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ThemeProfilesOptionsPanel
extends JPanel
implements OptionsComponent<CodeAreaThemeOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ThemeProfilesOptionsPanel.class);
    private final ProfileSelectionPanel selectionPanel;
    private final ThemeProfilesPanel profilesPanel = new ThemeProfilesPanel();

    public ThemeProfilesOptionsPanel() {
        this.selectionPanel = new ProfileSelectionPanel(this.profilesPanel);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.selectionPanel, "North");
        this.add((Component)this.profilesPanel, "Center");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setAddProfileOperation(ThemeProfilesPanel.AddProfileOperation addProfileOperation) {
        this.profilesPanel.setAddProfileOperation(addProfileOperation);
    }

    public void setEditProfileOperation(ThemeProfilesPanel.EditProfileOperation editProfileOperation) {
        this.profilesPanel.setEditProfileOperation(editProfileOperation);
    }

    public void setCopyProfileOperation(ThemeProfilesPanel.CopyProfileOperation copyProfileOperation) {
        this.profilesPanel.setCopyProfileOperation(copyProfileOperation);
    }

    public void setTemplateProfileOperation(ThemeProfilesPanel.TemplateProfileOperation templateProfileOperation) {
        this.profilesPanel.setTemplateProfileOperation(templateProfileOperation);
    }

    public void loadFromOptions(CodeAreaThemeOptionsImpl options) {
        this.profilesPanel.loadFromOptions(options);
        this.selectionPanel.setDefaultProfile(options.getSelectedProfile());
    }

    public void saveToOptions(CodeAreaThemeOptionsImpl options) {
        this.profilesPanel.saveToOptions(options);
        options.setSelectedProfile(this.selectionPanel.getDefaultProfile());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ThemeProfilesOptionsPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

