/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.bined.basic.EnterKeyHandlingMode;
import org.exbin.bined.basic.TabKeyHandlingMode;
import org.exbin.framework.bined.FileHandlingMode;
import org.exbin.framework.bined.options.impl.EditorOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class EditorOptionsPanel
extends JPanel
implements OptionsComponent<EditorOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(EditorOptionsPanel.class);
    private JComboBox<String> enterKeyHandlingModeComboBox;
    private JLabel enterKeyHandlingModeLabel;
    private JComboBox<String> fileHandlingModeComboBox;
    private JLabel fileHandlingModeLabel;
    private JComboBox<String> tabKeyHandlingModeComboBox;
    private JLabel tabKeyHandlingModeLabel;

    public EditorOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setFileHandlingModes(List<String> fileHandlingModes) {
        for (String fileHandlingMode : fileHandlingModes) {
            this.fileHandlingModeComboBox.addItem(fileHandlingMode);
        }
    }

    public void setEnterKeyHandlingModes(List<String> enterKeyHandlingModes) {
        for (String enterKeyHandlingMode : enterKeyHandlingModes) {
            this.enterKeyHandlingModeComboBox.addItem(enterKeyHandlingMode);
        }
    }

    public void setTabKeyHandlingModes(List<String> tabKeyHandlingModes) {
        for (String tabKeyHandlingMode : tabKeyHandlingModes) {
            this.tabKeyHandlingModeComboBox.addItem(tabKeyHandlingMode);
        }
    }

    public void saveToOptions(EditorOptionsImpl options) {
        options.setFileHandlingMode(FileHandlingMode.values()[this.fileHandlingModeComboBox.getSelectedIndex()]);
        options.setEnterKeyHandlingMode(EnterKeyHandlingMode.values()[this.enterKeyHandlingModeComboBox.getSelectedIndex()]);
        options.setTabKeyHandlingMode(TabKeyHandlingMode.values()[this.tabKeyHandlingModeComboBox.getSelectedIndex()]);
    }

    public void loadFromOptions(EditorOptionsImpl options) {
        this.fileHandlingModeComboBox.setSelectedIndex(options.getFileHandlingMode().ordinal());
        this.enterKeyHandlingModeComboBox.setSelectedIndex(options.getEnterKeyHandlingMode().ordinal());
        this.tabKeyHandlingModeComboBox.setSelectedIndex(options.getTabKeyHandlingMode().ordinal());
    }

    private void initComponents() {
        this.fileHandlingModeLabel = new JLabel();
        this.fileHandlingModeComboBox = new JComboBox();
        this.enterKeyHandlingModeLabel = new JLabel();
        this.enterKeyHandlingModeComboBox = new JComboBox();
        this.tabKeyHandlingModeLabel = new JLabel();
        this.tabKeyHandlingModeComboBox = new JComboBox();
        this.fileHandlingModeLabel.setText(this.resourceBundle.getString("fileHandlingModeLabel.text"));
        this.enterKeyHandlingModeLabel.setText(this.resourceBundle.getString("enterKeyHandlingModeLabel.text"));
        this.tabKeyHandlingModeLabel.setText(this.resourceBundle.getString("tabKeyHandlingModeLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileHandlingModeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.enterKeyHandlingModeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.tabKeyHandlingModeComboBox, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileHandlingModeLabel).addComponent(this.enterKeyHandlingModeLabel).addComponent(this.tabKeyHandlingModeLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fileHandlingModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileHandlingModeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enterKeyHandlingModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enterKeyHandlingModeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabKeyHandlingModeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabKeyHandlingModeComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new EditorOptionsPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

