/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.bined.options.gui.ColorProfilesPanel;
import org.exbin.framework.bined.options.gui.ProfileSelectionPanel;
import org.exbin.framework.bined.options.impl.CodeAreaColorOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ColorProfilesOptionsPanel
extends JPanel
implements OptionsComponent<CodeAreaColorOptionsImpl> {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ColorProfilesOptionsPanel.class);
    private final ProfileSelectionPanel selectionPanel;
    private final ColorProfilesPanel profilesPanel = new ColorProfilesPanel();

    public ColorProfilesOptionsPanel() {
        this.selectionPanel = new ProfileSelectionPanel(this.profilesPanel);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.add((Component)this.selectionPanel, "North");
        this.add((Component)this.profilesPanel, "Center");
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setAddProfileOperation(ColorProfilesPanel.AddProfileOperation addProfileOperation) {
        this.profilesPanel.setAddProfileOperation(addProfileOperation);
    }

    public void setEditProfileOperation(ColorProfilesPanel.EditProfileOperation editProfileOperation) {
        this.profilesPanel.setEditProfileOperation(editProfileOperation);
    }

    public void setCopyProfileOperation(ColorProfilesPanel.CopyProfileOperation copyProfileOperation) {
        this.profilesPanel.setCopyProfileOperation(copyProfileOperation);
    }

    public void setTemplateProfileOperation(ColorProfilesPanel.TemplateProfileOperation templateProfileOperation) {
        this.profilesPanel.setTemplateProfileOperation(templateProfileOperation);
    }

    public void loadFromOptions(CodeAreaColorOptionsImpl options) {
        this.profilesPanel.loadFromOptions(options);
        this.selectionPanel.setDefaultProfile(options.getSelectedProfile());
    }

    public void saveToOptions(CodeAreaColorOptionsImpl options) {
        this.profilesPanel.saveToOptions(options);
        options.setSelectedProfile(this.selectionPanel.getDefaultProfile());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ColorProfilesOptionsPanel());
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
    }
}

