/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;
import org.exbin.framework.bined.model.ColorProfileTableModel;
import org.exbin.framework.bined.options.gui.ColorCellTableEditor;
import org.exbin.framework.bined.options.gui.ColorCellTableRenderer;
import org.exbin.framework.bined.options.gui.PreviewPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class ColorProfilePanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(ColorProfilePanel.class);
    private final PreviewPanel previewPanel = new PreviewPanel(PreviewPanel.PreviewType.WITH_SEARCH);
    private final ColorProfileTableModel colorTableModel = new ColorProfileTableModel();
    private JScrollPane colorsScrollPane;
    private JTable colorsTable;
    private JPanel preferencesPanel;

    public ColorProfilePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.colorsTable.setDefaultRenderer(Color.class, new ColorCellTableRenderer());
        this.colorsTable.setDefaultEditor(Color.class, new ColorCellTableEditor());
        this.add((Component)this.previewPanel, "Center");
        ExtCodeArea codeArea = this.previewPanel.getCodeArea();
        this.colorTableModel.setColorProfile((ExtendedCodeAreaColorProfile)codeArea.getColorsProfile());
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setColorProfile(@Nonnull ExtendedCodeAreaColorProfile colorProfile) {
        ExtendedCodeAreaColorProfile newColorProfile = colorProfile.createCopy();
        ExtCodeArea codeArea = this.previewPanel.getCodeArea();
        codeArea.setColorsProfile((CodeAreaColorsProfile)newColorProfile);
        this.colorTableModel.setColorProfile(newColorProfile);
    }

    @Nonnull
    public ExtendedCodeAreaColorProfile getColorProfile() {
        ExtCodeArea codeArea = this.previewPanel.getCodeArea();
        ExtendedCodeAreaColorProfile profile = (ExtendedCodeAreaColorProfile)codeArea.getColorsProfile();
        return Objects.requireNonNull(profile).createCopy();
    }

    private void initComponents() {
        this.preferencesPanel = new JPanel();
        this.colorsScrollPane = new JScrollPane();
        this.colorsTable = new JTable();
        this.setLayout(new BorderLayout());
        this.preferencesPanel.setLayout(new BorderLayout());
        this.colorsTable.setModel(this.colorTableModel);
        this.colorsScrollPane.setViewportView(this.colorsTable);
        this.preferencesPanel.add((Component)this.colorsScrollPane, "Center");
        this.add((Component)this.preferencesPanel, "West");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new ColorProfilePanel());
    }
}

