/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.options.gui;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.bined.options.impl.BinaryAppearanceOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinaryAppearanceOptionsPanel
extends JPanel
implements OptionsComponent<BinaryAppearanceOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinaryAppearanceOptionsPanel.class);
    private JCheckBox multiFileModeCheckBox;

    public BinaryAppearanceOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(BinaryAppearanceOptionsImpl options) {
        this.multiFileModeCheckBox.setSelected(options.isMultiFileMode());
    }

    public void saveToOptions(BinaryAppearanceOptionsImpl options) {
        options.setMultiFileMode(this.multiFileModeCheckBox.isSelected());
    }

    private void initComponents() {
        this.multiFileModeCheckBox = new JCheckBox();
        this.setName("Form");
        this.multiFileModeCheckBox.setSelected(true);
        this.multiFileModeCheckBox.setText(this.resourceBundle.getString("multiFileModeCheckBox.text"));
        this.multiFileModeCheckBox.setName("multiFileModeCheckBox");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.multiFileModeCheckBox, -1, 147, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.multiFileModeCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinaryAppearanceOptionsPanel());
    }

    private void setModified(boolean modified) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }
}

