/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.model;

import java.awt.Color;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.exbin.bined.color.BasicCodeAreaDecorationColorType;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.extended.color.CodeAreaUnprintablesColorType;
import org.exbin.bined.highlight.swing.color.CodeAreaColorizationColorType;
import org.exbin.bined.highlight.swing.color.CodeAreaMatchColorType;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;

@ParametersAreNonnullByDefault
public class ColorProfileTableModel
implements TableModel {
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private final List<ColorRow> rows = new ArrayList<ColorRow>();
    private ExtendedCodeAreaColorProfile colorProfile;

    public ColorProfileTableModel() {
        this.init();
    }

    private void init() {
        this.rows.add(new ColorRow("Text color", (CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR));
        this.rows.add(new ColorRow("Text background", (CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND));
        this.rows.add(new ColorRow("Selection text color", (CodeAreaColorType)CodeAreaBasicColors.SELECTION_COLOR));
        this.rows.add(new ColorRow("Selection background", (CodeAreaColorType)CodeAreaBasicColors.SELECTION_BACKGROUND));
        this.rows.add(new ColorRow("Selection mirror text color", (CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_COLOR));
        this.rows.add(new ColorRow("Selection mirror background", (CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_BACKGROUND));
        this.rows.add(new ColorRow("Alternate text color", (CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_COLOR));
        this.rows.add(new ColorRow("Alternate background", (CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_BACKGROUND));
        this.rows.add(new ColorRow("Cursor color", (CodeAreaColorType)CodeAreaBasicColors.CURSOR_COLOR));
        this.rows.add(new ColorRow("Cursor negative color", (CodeAreaColorType)CodeAreaBasicColors.CURSOR_NEGATIVE_COLOR));
        this.rows.add(new ColorRow("Decoration line color", (CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE));
        this.rows.add(new ColorRow("Control codes text color", (CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_COLOR));
        this.rows.add(new ColorRow("Control codes background", (CodeAreaColorType)CodeAreaColorizationColorType.CONTROL_CODES_BACKGROUND));
        this.rows.add(new ColorRow("Upper codes text color", (CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_COLOR));
        this.rows.add(new ColorRow("Upper codes background color", (CodeAreaColorType)CodeAreaColorizationColorType.UPPER_CODES_BACKGROUND));
        this.rows.add(new ColorRow("Search match text color", (CodeAreaColorType)CodeAreaMatchColorType.MATCH_COLOR));
        this.rows.add(new ColorRow("Search match background", (CodeAreaColorType)CodeAreaMatchColorType.MATCH_BACKGROUND));
        this.rows.add(new ColorRow("Active match text color", (CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_COLOR));
        this.rows.add(new ColorRow("Active match background", (CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_BACKGROUND));
        this.rows.add(new ColorRow("Unprintable characters text color", (CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_COLOR));
        this.rows.add(new ColorRow("Unprintable characters background", (CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_BACKGROUND));
    }

    @Nullable
    public ExtendedCodeAreaColorProfile getColorProfile() {
        return this.colorProfile;
    }

    public void setColorProfile(ExtendedCodeAreaColorProfile colorProfile) {
        this.colorProfile = colorProfile;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    @Nonnull
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Color";
            }
            case 1: {
                return "Value";
            }
        }
        throw ColorProfileTableModel.createUnexpectedColumnException(columnIndex);
    }

    @Override
    @Nonnull
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Color.class;
            }
        }
        throw ColorProfileTableModel.createUnexpectedColumnException(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw ColorProfileTableModel.createUnexpectedColumnException(columnIndex);
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.rows.get((int)rowIndex).colorName;
            }
            case 1: {
                return this.colorProfile == null ? null : this.colorProfile.getColor(this.rows.get((int)rowIndex).colorType);
            }
        }
        throw ColorProfileTableModel.createUnexpectedColumnException(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                if (this.colorProfile == null) {
                    throw new IllegalStateException("Editing is not allowed when color profile was not set");
                }
                this.colorProfile.setColor(this.rows.get((int)rowIndex).colorType, (Color)aValue);
                this.notifyAllListeners(rowIndex);
                return;
            }
        }
        throw ColorProfileTableModel.createUnexpectedColumnException(columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAllListeners(int rowNumber) {
        this.listeners.forEach(listener -> listener.tableChanged(new TableModelEvent(this, rowNumber, 1, 0)));
    }

    private void notifyAllListeners() {
        this.listeners.forEach(listener -> listener.tableChanged(new TableModelEvent(this, 0, this.rows.size() - 1, 1, 0)));
    }

    @Nonnull
    private static InvalidParameterException createUnexpectedColumnException(int columnIndex) {
        return new InvalidParameterException("Unexpected column index " + columnIndex);
    }

    @ParametersAreNonnullByDefault
    private static class ColorRow {
        String colorName;
        CodeAreaColorType colorType;

        public ColorRow(String colorName, CodeAreaColorType colorType) {
            this.colorName = colorName;
            this.colorType = colorType;
        }
    }
}

